/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.build.GetTextFeaturesMapper;
import oracle.dmt.dataminer.core.model.common.build.TextAttribute;
import oracle.dmt.dataminer.core.model.common.build.TextFeature;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetTextAttributesFeaturesQuery
extends SqlQuery<TextFeature, OraclePreparedStatement> {
    private static String BASE_QUERY = "SELECT ATTRIBUTE_NAME, FEATURE_NAME, FREQUENCY, TYPE\nFROM (\n  SELECT TOKENS.ATTRIBUTE_NAME, FEATURE_NAME, FREQUENCY, {$TYPE_COLUMN} TYPE\n  FROM TABLE(ODM_UTIL.SYS_DM_TEXT_DF('{$MODEL}', '{$ATTRIBUTE}')) TOKENS,\n       ({$XFORM_TABLE})\n)";
    private ISqlQuery<OraclePreparedStatement> queryGenerator;
    private List<TextAttribute> attributes;

    public GetTextAttributesFeaturesQuery(Version version, List<TextAttribute> list) {
        super(version, new GetTextFeaturesMapper());
        assert (list != null);
        this.attributes = list;
        this.queryGenerator = DbVersionHelper.isDB122Up(this.dbVersion) ? new Db122Query() : new DBOriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.queryGenerator.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    extends DBOriginalQuery {
        private Db122Query() {
        }

        @Override
        protected String getXformTable() {
            return "SELECT * FROM USER_MINING_MODEL_XFORMS\n       WHERE MODEL_NAME = '{$MODEL}' AND ATTRIBUTE_NAME = '{$ATTRIBUTE}' AND ATTRIBUTE_SPEC IS NOT NULL";
        }

        @Override
        protected String getTypeExpression() {
            return "REGEXP_REPLACE(ATTRIBUTE_SPEC, '.*\\((TOKEN_TYPE|token_type):(.+)?\\)', '\\2')";
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("TYPE_COLUMN", this.getTypeExpression());
            hashMap.put("XFORM_TABLE", this.getXformTable());
            String string = StringUtils.getReplacedString(BASE_QUERY, hashMap);
            String string2 = GetTextAttributesFeaturesQuery.this.attributes.stream().map(textAttribute -> {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("MODEL", textAttribute.getModel());
                hashMap.put("ATTRIBUTE", textAttribute.getAttribute());
                return StringUtils.getReplacedString(string, hashMap);
            }).collect(Collectors.joining("\nUNION ALL\n"));
            string2 = string2 + "\nORDER BY FREQUENCY DESC, FEATURE_NAME";
            return string2;
        }

        protected String getXformTable() {
            return "SELECT * FROM USER_MINING_MODEL_ATTRIBUTES\n       WHERE MODEL_NAME = '{$MODEL}' AND ATTRIBUTE_NAME = '{$ATTRIBUTE}'";
        }

        protected String getTypeExpression() {
            return "SUBSTR(ATTRIBUTE_SPEC, INSTR(ATTRIBUTE_SPEC,'TOKEN_TYPE:',-1,1)+LENGTH('TOKEN_TYPE:'), 10)";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setFetchSize(300);
        }
    }
}

