/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetPartitionsColumnsQuery
extends SqlQuery<PartitionColumn, OraclePreparedStatement> {
    private static final String MODEL_PARAM = "MODEL_NAME";
    private List<String> models;

    public GetPartitionsColumnsQuery(Version version, List<String> list) {
        super(version, new SqlDefaultMapper<PartitionColumn>(PartitionColumn.class));
        this.models = list;
    }

    @Override
    public String getSQLCommand() {
        String string = Conditional.in(MODEL_PARAM, this.models);
        String string2 = "SELECT DISTINCT mp.column_name as COLUMN_NAME, ma.data_type as DATA_TYPE \nFROM all_mining_model_partitions mp, all_mining_model_attributes ma\nWHERE mp.{$MODEL}\nAND   mp.model_name  = ma.model_name\nAND   mp.column_name = ma.attribute_name";
        string2 = string2.replace("{$MODEL}", string);
        return string2;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringParameterList(oraclePreparedStatement, MODEL_PARAM, this.models);
    }
}

