/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.nb;

import java.sql.SQLException;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlIntegerMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetTotalCountProbabilitiesQuery
extends SqlBaseModelQuery<Integer, OraclePreparedStatement> {
    private boolean targetIsString;
    private List<? extends Object> targets;
    private ISqlQuery<OraclePreparedStatement> query;

    public GetTotalCountProbabilitiesQuery(Version version, ModelDescriptor modelDescriptor, List<? extends Object> list) {
        super(version, new SqlIntegerMapper(), modelDescriptor);
        this.targets = list;
        this.targetIsString = list.get(0) instanceof String;
        this.query = DbVersionHelper.isDB122Up(version) ? new DB122Query() : new OriginalQuery();
    }

    @Override
    public String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
        if (this.targetIsString) {
            SqlUtils.setStringParameterList(oraclePreparedStatement, "TARGET_VALUE", this.targets);
        } else {
            SqlUtils.setBigDecimalParameterList(oraclePreparedStatement, "TARGET_VALUE", this.targets);
        }
    }

    private class DB122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private DB122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("COUNT(*)").from(GetTotalCountProbabilitiesQuery.this.getViewName("DM$VV")).where(Conditional.equals("PARTITION_NAME", GetTotalCountProbabilitiesQuery.this.getPartitionId()), Conditional.in("TARGET_VALUE", GetTotalCountProbabilitiesQuery.this.targets));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetTotalCountProbabilitiesQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetTotalCountProbabilitiesQuery.this.targetIsString ? "T.TARGET_ATTRIBUTE_STR_VALUE" : "T.TARGET_ATTRIBUTE_NUM_VALUE";
            SqlBuilder sqlBuilder = new SqlBuilder().select("COUNT(*)").from("TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model)) T,TABLE(T.CONDITIONALS) C").where(Conditional.in(string, "TARGET_VALUE", GetTotalCountProbabilitiesQuery.this.targets));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetTotalCountProbabilitiesQuery.this.getQualifiedName());
        }
    }
}

