/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.Array;
import java.sql.SQLException;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetModelsWithCostMatrixMapper;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;

public class GetModelsWithCostMatrixQuery
extends SqlQuery<MiningModelSettings, OracleCallableStatement> {
    private static final String[] COLUMNS = new String[]{"USER_NAME", "OBJECT_NAME"};
    private List<String> _users;
    private List<String> _models;

    public GetModelsWithCostMatrixQuery(Version version, String string, String string2, String string3, List<String> list, List<String> list2) {
        super(version, new GetModelsWithCostMatrixMapper(string, string2, string3));
        assert (list != null) : "User Name List Cannot be Null.";
        assert (list2 != null) : "Model Name List Cannot be Null.";
        this._users = list;
        this._models = list2;
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select(COLUMNS).from("TABLE(ODMRSYS.ODMR_UTIL.GET_MODELS_WITH_COST_MATRIX(?,?))");
        return sqlBuilder.toString();
    }

    @Override
    public void setParameters(OracleCallableStatement oracleCallableStatement) throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)oracleCallableStatement.getConnection();
        Array array = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)this._users.toArray(new String[this._users.size()]));
        Array array2 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)this._models.toArray(new String[this._models.size()]));
        oracleCallableStatement.setArray(1, array);
        oracleCallableStatement.setArray(2, array2);
    }
}

