/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlIntegerMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetBuildRowsCountQuery
extends SqlBaseModelQuery<Integer, OraclePreparedStatement> {
    private static final String NUM_ROWS = "NUM_ROWS";

    public GetBuildRowsCountQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlIntegerMapper(), modelDescriptor);
        assert (DbVersionHelper.isDB122Up(version)) : "This query works only for 12.2 and Up";
    }

    @Override
    protected String getSQLCommand() {
        String string = new SqlBuilder().select("SUM({$COLUMN})").from(this.getViewName("DM$VG")).where(Conditional.equals("NAME", NUM_ROWS), Conditional.equals("PARTITION_NAME", this.getPartitionId())).toString();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("COLUMN", "NUMERIC_VALUE");
        String string2 = StringUtils.getReplacedString(string, hashMap);
        return string2;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName(oraclePreparedStatement, "NAME", NUM_ROWS);
        SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
    }
}

