/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.ar.ap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.model.generated.server.DmItems;
import oracle.dmt.dataminer.core.utils.Patterns;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleResultSet;

public class GetItemSetsMapper
extends SqlMapper<ItemSet> {
    private List<String> aggregates;
    private int transactionCount;

    public GetItemSetsMapper(Version version, List<String> list, int n) {
        super(version);
        assert (list != null);
        this.aggregates = list;
        this.transactionCount = n;
    }

    @Override
    public ItemSet map(ResultSet resultSet) throws Exception {
        ItemSet itemSet = DbVersionHelper.isDB122Up(this.dbVersion) ? this.map122Up(resultSet) : this.mapOriginal(resultSet);
        return itemSet;
    }

    private ItemSet mapOriginal(ResultSet resultSet) throws SQLException {
        Integer n = resultSet.getInt("ITEMSET_ID");
        Integer n2 = resultSet.getInt("NUMBER_OF_ITEMS");
        Double d = resultSet.getDouble("SUPPORT");
        DmItems dmItems = (DmItems)((OracleResultSet)resultSet).getORAData("ITEMS", DmItems.getORADataFactory());
        List<Item> list = Item.createItemsFrom(dmItems);
        ItemSet itemSet = new ItemSet(n, list, d, n2);
        return itemSet;
    }

    private ItemSet map122Up(ResultSet resultSet) throws SQLException {
        Integer n = resultSet.getInt("ITEMSET_ID");
        Integer n2 = resultSet.getInt("NUMBER_OF_ITEMS");
        Double d = resultSet.getDouble("SUPPORT");
        List<Item> list = this.parseItems(resultSet, n2, d);
        ItemSet itemSet = new ItemSet(n, list, d, n2);
        return itemSet;
    }

    private List<Item> parseItems(ResultSet resultSet, int n, Double d) throws SQLException {
        String string = resultSet.getString("INAMES");
        String string2 = resultSet.getString("ISUBNAMES");
        String string3 = resultSet.getString("IVALUES");
        String[] stringArray2 = new String[this.aggregates.size()];
        int n2 = 0;
        for (String stringArray3 : this.aggregates) {
            stringArray2[n2++] = resultSet.getString("I" + stringArray3.toUpperCase() + "S");
        }
        String[] stringArray4 = string != null ? string.split(Strings.SEPARATOR) : new String[n];
        String[] stringArray = string2 != null ? string2.split(Strings.SEPARATOR) : new String[n];
        String[] stringArray3 = string3 != null ? string3.split(Strings.SEPARATOR) : new String[n];
        String[][] stringArray5 = new String[this.aggregates.size()][n];
        for (int arrayList = 0; arrayList < stringArray5.length; ++arrayList) {
            stringArray5[arrayList] = stringArray2[arrayList].split(Strings.SEPARATOR);
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(n);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string4 = stringArray4[i];
            String string5 = stringArray[i];
            String string6 = stringArray3[i];
            Double d2 = null;
            boolean bl2 = bl = string6 != null && Patterns.DIGIT.matcher(string6).matches();
            if (bl) {
                d2 = Double.parseDouble(string6);
                string6 = null;
            }
            Item item = new Item(string4, string5, d2, string6);
            int n3 = 0;
            for (String string7 : this.aggregates) {
                Double d3 = Double.parseDouble(stringArray5[n3++][i]);
                Double d4 = d3 / ((double)this.transactionCount * d);
                item.addAggregate(string7, d3, d4);
            }
            arrayList.add(item);
        }
        return arrayList;
    }
}

