/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.io.IOException;
import java.io.Reader;
import oracle.dbtools.http.Client;
import oracle.dbtools.util.StreamCopy;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    public final T handleResponse(HttpResponse resp) throws ClientProtocolException, IOException {
        T result = null;
        StatusLine status = resp.getStatusLine();
        int code = status.getStatusCode();
        switch (code) {
            case 200: {
                result = this.handleSuccess(resp);
                break;
            }
            case 500: {
                this.report500Error(resp);
            }
            default: {
                result = this.handleError(resp);
            }
        }
        return result;
    }

    protected final void report500Error(HttpResponse resp) throws IOException {
        StatusLine status = resp.getStatusLine();
        Header contentType = resp.getEntity().getContentType();
        throw this.createInternalServerError(status.toString(), StreamCopy.string((Reader)Client.createReader(resp)), contentType.getValue());
    }

    protected abstract T handleSuccess(HttpResponse var1) throws ClientProtocolException, IOException;

    protected abstract IOException createInternalServerError(String var1, String var2, String var3);

    protected abstract T handleError(HttpResponse var1) throws ClientProtocolException, IOException;
}

