/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.tsql;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.util.FileUtil;

public class EmulationManager {
    public static final String EMULATIONPKGNAME = "utils";
    public static final String EMULATIONPKGHEADER = "emulation/utils.pks";
    private static final String EMULATIONPKGBODY = "emulation/utils.pkb";
    public static final String EMULATION_SYBASETYPE_SETTING = "DATABASE_TYPE       VARCHAR2(10)  :=  SYBASE;";
    public static final String EMULATION_SQLSERVERTYPE_SETTING = "DATABASE_TYPE       VARCHAR2(10)  :=  SQLSERVER;";
    private static EmulationManager m_em = null;

    public TranslationResult getEmulationPackage(TranslationDBObjectReference translationDBObjectReference, Object object, ITranslationContext iTranslationContext, boolean bl, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2 = this.getEmulationBody();
        stringBuffer = this.getEmulationHeader();
        stringBuffer = this.setDatabaseType(stringBuffer, string);
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer = this.setTableTriggerCollectionTypes(stringBuffer, string2);
        }
        ArrayList<TranslationDBObject> arrayList = new ArrayList<TranslationDBObject>();
        TranslationDBObject translationDBObject = new TranslationDBObject(translationDBObjectReference, stringBuffer.toString());
        TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, stringBuffer2.toString());
        arrayList.add(translationDBObject2);
        TranslationResult translationResult = new TranslationResult(translationDBObject, arrayList, null);
        return translationResult;
    }

    private StringBuffer setTableTriggerCollectionTypes(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.lastIndexOf("END UTILS;");
        return stringBuffer.insert(n, string + "\n");
    }

    private StringBuffer setDatabaseType(StringBuffer stringBuffer, String string) {
        if (string != null && string.equalsIgnoreCase(EMULATION_SQLSERVERTYPE_SETTING)) {
            int n = stringBuffer.indexOf(EMULATION_SYBASETYPE_SETTING);
            stringBuffer = stringBuffer.replace(n, n + EMULATION_SYBASETYPE_SETTING.length(), EMULATION_SQLSERVERTYPE_SETTING);
        }
        return stringBuffer;
    }

    private StringBuffer getEmulationHeader() {
        return this.fileToString(EMULATIONPKGHEADER);
    }

    private StringBuffer fileToString(String string) {
        StringBuffer stringBuffer = null;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        try {
            stringBuffer = new StringBuffer(FileUtil.inputStreamToString((InputStream)inputStream));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer;
    }

    private StringBuffer getEmulationBody() {
        return this.fileToString(EMULATIONPKGBODY);
    }

    public static EmulationManager getEmulationManager() {
        return new EmulationManager();
    }

    public String getEmulationPackageName() {
        return EMULATIONPKGNAME;
    }

    public String getEmulationPackage(String string) {
        StringBuffer stringBuffer = this.getEmulationBody();
        StringBuffer stringBuffer2 = this.getEmulationHeader();
        stringBuffer2 = this.setDatabaseType(stringBuffer2, string);
        stringBuffer2.append("\n/\n");
        stringBuffer2.append(stringBuffer + "\n/\n");
        return stringBuffer2.toString();
    }
}

