/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.xml;

import java.net.URL;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.plugin.api.logging.Log;
import org.w3c.dom.Node;

public class JAXBErrorLog
implements ValidationEventHandler {
    private final Log log;

    public JAXBErrorLog(Log log) {
        this.log = log;
    }

    public boolean handleEvent(ValidationEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        boolean retVal = true;
        String location = this.getLocation(event);
        StringBuilder msg = new StringBuilder();
        msg.append(event.getMessage());
        msg.append(" location: ");
        msg.append(location);
        switch (event.getSeverity()) {
            case 0: {
                this.log.warning(msg.toString());
                break;
            }
            case 1: 
            case 2: {
                this.log.severe(msg.toString());
                retVal = false;
                break;
            }
            default: {
                this.log.fine(msg.toString());
            }
        }
        if (retVal) {
            throw UnrecoverableException.unrecoverable(new IllegalStateException(msg.toString()));
        }
        return retVal;
    }

    private String getLocation(ValidationEvent event) {
        StringBuffer msg = new StringBuffer();
        ValidationEventLocator locator = event.getLocator();
        if (locator != null) {
            URL url = locator.getURL();
            Object obj = locator.getObject();
            Node node = locator.getNode();
            int line = locator.getLineNumber();
            if (url != null || line != -1) {
                msg.append("line " + line);
                if (url != null) {
                    msg.append(" of " + url);
                }
            } else if (obj != null) {
                msg.append(" obj: " + obj.toString());
            } else if (node != null) {
                msg.append(" node: " + node.toString());
            }
        } else {
            msg.append("unavailable");
        }
        return msg.toString();
    }
}

