/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import oracle.dbtools.common.util.Arrays;
import oracle.dbtools.common.xml.JAXBContexts;
import oracle.dbtools.common.xml.JAXBErrorLog;
import oracle.dbtools.common.xml.XMLSerializerOptions;
import oracle.dbtools.common.xml.XMLSerializers;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.logging.Log;

@Provides
public class JAXBContextsProvider
implements JAXBContexts {
    private final XMLSerializerOptions defaultFormatting;
    private final Log log;
    private final XMLSerializers xml;

    @Inject
    public JAXBContextsProvider(Log log, XMLSerializers xml) {
        this.log = log;
        this.xml = xml;
        this.defaultFormatting = xml.options().indent(1).emitDecl(true).build();
    }

    @Override
    public JAXBContext jaxbContext(Class<?> rootType, Class<?> ... otherTypes) throws JAXBException {
        Class[] types = Arrays.flatten(new Class[]{rootType}, otherTypes);
        JAXBContext context = JAXBContext.newInstance((Class[])types);
        return context;
    }

    @Override
    public <T> T read(InputStream stream, Class<T> rootType, Class<?> ... otherTypes) throws JAXBException {
        JAXBContext context = this.jaxbContext(rootType, otherTypes);
        Unmarshaller um = context.createUnmarshaller();
        um.setEventHandler((ValidationEventHandler)new JAXBErrorLog(this.log));
        T root = rootType.cast(um.unmarshal(stream));
        return root;
    }

    @Override
    public <T> T read(Reader stream, Class<T> rootType, Class<?> ... otherTypes) throws JAXBException {
        JAXBContext context = this.jaxbContext(rootType, otherTypes);
        Unmarshaller um = context.createUnmarshaller();
        um.setEventHandler((ValidationEventHandler)new JAXBErrorLog(this.log));
        T root = rootType.cast(um.unmarshal(stream));
        return root;
    }

    @Override
    public void write(OutputStream stream, Object rootElement, Class<?> rootType, Class<?> ... otherTypes) throws JAXBException {
        this.write(stream, this.defaultFormatting, rootElement, rootType, otherTypes);
    }

    @Override
    public void write(OutputStream stream, XMLSerializerOptions serializerOptions, Object rootElement, Class<?> rootType, Class<?> ... otherTypes) throws JAXBException {
        JAXBContext context = this.jaxbContext(rootType, otherTypes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setEventHandler((ValidationEventHandler)new JAXBErrorLog(this.log));
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        Result result = this.xml.serializer(stream, serializerOptions);
        marshaller.marshal(rootElement, result);
    }

    @Override
    public void write(Writer stream, Object rootElement, Class<?> rootType, Class<?> ... otherTypes) throws JAXBException {
        this.write(stream, this.defaultFormatting, rootElement, rootType, otherTypes);
    }

    @Override
    public void write(Writer stream, XMLSerializerOptions serializerOptions, Object rootElement, Class<?> rootType, Class<?> ... otherTypes) throws JAXBException {
        JAXBContext context = this.jaxbContext(rootType, otherTypes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setEventHandler((ValidationEventHandler)new JAXBErrorLog(this.log));
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        Result result = this.xml.serializer(stream, serializerOptions);
        marshaller.marshal(rootElement, result);
    }

    @Override
    public XMLSerializers xmlSerializers() {
        return this.xml;
    }
}

