/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PSelector;
import oracle.dbtools.common.x3p.impl.X3PAttributeImpl;

class X3PAttributesImpl
implements X3PAttributes {
    private final List<X3PAttribute> attributes = new ArrayList<X3PAttribute>();
    private final Map<QName, String> byName = new HashMap<QName, String>();

    X3PAttributesImpl() {
    }

    @Override
    public Boolean apply(X3PSelector x) {
        if (x instanceof X3PElement) {
            return this.matches(((X3PElement)x).getAttrs());
        }
        if (x instanceof X3PAttributes) {
            return this.matches((X3PAttributes)X3PAttributes.class.cast(x));
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X3PAttributes)) {
            return false;
        }
        X3PAttributes other = (X3PAttributes)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String get(int i) {
        return this.attributes.get(i).getValue();
    }

    @Override
    public String get(QName name) {
        return this.byName.get(name);
    }

    @Override
    public String get(String name) {
        return this.byName.get(new QName(name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    @Override
    public Iterator<X3PAttribute> iterator() {
        return this.attributes.iterator();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (X3PAttribute a : this) {
            QName name = a.getName();
            if (name.getPrefix().isEmpty()) {
                b.append(name.getLocalPart());
            } else {
                b.append(name.getPrefix());
                b.append(':');
                b.append(name.getLocalPart());
            }
            b.append('=');
            b.append(a.getValue());
            b.append(", ");
        }
        b.append(']');
        return b.toString();
    }

    void add(QName name, String value) {
        X3PAttributeImpl a = new X3PAttributeImpl(name, value);
        this.add(a);
    }

    void add(String name, String value) {
        this.add(new QName(name), value);
    }

    void add(X3PAttribute attribute) {
        this.attributes.add(attribute);
        this.byName.put(attribute.getName(), attribute.getValue());
    }

    private Boolean matches(X3PAttributes others) {
        if (this.attributes == null || this.attributes.size() == 0) {
            return true;
        }
        if (others == null) {
            return false;
        }
        for (X3PAttribute a : this.attributes) {
            String other;
            String thiz = a.getValue();
            if (thiz.equals(other = others.get(a.getName()))) continue;
            return false;
        }
        return true;
    }
}

