/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PFilterChain;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.impl.Event;
import oracle.dbtools.common.x3p.impl.SingleEvent;
import oracle.dbtools.common.x3p.impl.X3PReaderAdaptor;

class Chain
implements X3PFilterChain {
    private final List<X3PFilter> filters = new ArrayList<X3PFilter>();
    private final Deque<Input> input = new ArrayDeque<Input>();

    public Chain(X3PFilter ... filters) {
        for (X3PFilter filter : filters) {
            this.filters.add(filter);
        }
    }

    @Override
    public X3PReader filter(Iterable<X3PReader> input) {
        return X3PReaderAdaptor.wrap(this.filter(X3PReaderAdaptor.unwrap(input))).iterator().next();
    }

    public Iterator<Event> filter(Iterator<Event> input) {
        this.input.push(new Input(-1, input));
        return new EventIterator();
    }

    private class Input {
        private final Iterator<Event> events;
        private final int filter;

        public Input(int filter, Iterator<Event> events) {
            this.filter = filter;
            this.events = events;
        }

        public Iterator<Event> getEvents() {
            return this.events;
        }

        public int getFilter() {
            return this.filter;
        }

        public String toString() {
            return "inserted by: " + this.filter + ", " + this.events;
        }
    }

    private class EventIterator
    extends AbstractIterator<Event>
    implements Closeable {
        private boolean end = false;

        private EventIterator() {
        }

        @Override
        public void close() {
            for (Input i : Chain.this.input) {
                Closeables.close(i.getEvents());
            }
        }

        public String toString() {
            return Chain.this.input.toString();
        }

        @Override
        protected Event advance() {
            Event event = null;
            try {
                if (Chain.this.input.isEmpty()) {
                    this.end = true;
                    event = null;
                    return null;
                }
                Event e = null;
                while (!this.end && null == e) {
                    Input current = (Input)Chain.this.input.peek();
                    while (current != null && !current.getEvents().hasNext()) {
                        Closeables.close(current.getEvents());
                        Chain.this.input.pop();
                        current = (Input)Chain.this.input.peek();
                    }
                    if (Chain.this.input.isEmpty()) {
                        this.end = true;
                        event = null;
                        return null;
                    }
                    int filterOffset = current.getFilter() + 1;
                    e = current.getEvents().next();
                    if (filterOffset < Chain.this.filters.size()) {
                        for (int i = filterOffset; i < Chain.this.filters.size(); ++i) {
                            X3PFilter filter = (X3PFilter)Chain.this.filters.get(i);
                            ChainMutator mutator = new ChainMutator();
                            e.invoke(filter, mutator);
                            if (!mutator.before.isEmpty()) {
                                Chain.this.input.push(new Input(i, new SingleEvent(e)));
                                for (Iterator<Event> iter : mutator.before) {
                                    Chain.this.input.push(new Input(i, iter));
                                }
                            }
                            if (!mutator.after.isEmpty()) {
                                for (Iterator<Event> iter : mutator.after) {
                                    Chain.this.input.push(new Input(i, iter));
                                }
                            }
                            if (mutator.suppress) {
                                Closeables.close(e);
                            }
                            if (!mutator.suppress && mutator.before.isEmpty()) continue;
                            e = null;
                            break;
                        }
                    }
                    event = e;
                }
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
            return event;
        }
    }

    private final class ChainMutator
    implements X3PFilter.Mutator {
        List<Iterator<Event>> after = new ArrayList<Iterator<Event>>();
        List<Iterator<Event>> before = new ArrayList<Iterator<Event>>();
        boolean suppress = false;

        private ChainMutator() {
        }

        @Override
        public void after(Iterable<X3PReader> readers) {
            this.after.add(X3PReaderAdaptor.unwrap(readers));
        }

        @Override
        public void before(Iterable<X3PReader> readers) {
            this.before.add(X3PReaderAdaptor.unwrap(readers));
        }

        @Override
        public void suppress() {
            this.suppress = true;
        }
    }
}

