/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.x3p.MatchFilter;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PBuilder;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PSelector;
import oracle.dbtools.common.x3p.X3PWriterOptions;

public abstract class ContentFilter
extends MatchFilter {
    private X3PBuilder builder = X3PBuilder.builder(true);
    private final Selector<X3PSelector> condition;
    private final X3PWriterOptions options;

    protected ContentFilter(X3PWriterOptions options, X3PPath ... paths) {
        super(ContentFilter.within(paths));
        this.condition = Selectors.or(Iterables.transform(Arrays.asList(paths), new Transform<X3PPath, Selector<X3PSelector>>(){

            @Override
            public Selector<X3PSelector> apply(X3PPath x) {
                return x;
            }
        }));
        this.options = options;
    }

    @Override
    protected void characters(X3PPath path, char[] ch, int offset, int length, X3PFilter.Mutator mutator) {
        this.builder.characters(ch, offset, length);
    }

    protected abstract void content(InputStream var1);

    @Override
    protected void endElement(X3PPath path, X3PFilter.Mutator mutator) {
        this.builder.endElement(path.lastSegment());
        if (this.matchesPath(path)) {
            try {
                this.content(X3PFactory.newStream(this.builder.build(), this.options));
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
            this.builder = X3PBuilder.builder(true);
        }
    }

    protected void startContent(X3PPath path, X3PAttributes atts) {
    }

    @Override
    protected void startElement(X3PPath path, X3PAttributes atts, X3PFilter.Mutator mutator) {
        if (this.matchesPath(path)) {
            this.startContent(path, atts);
        }
        this.builder.startElement(path.lastSegment(), atts);
    }

    private boolean matchesPath(X3PPath path) {
        return (Boolean)this.condition.apply(path);
    }

    private static Selector<X3PSelector> within(X3PPath ... paths) {
        return Selectors.or(Iterables.transform(Arrays.asList(paths), new Transform<X3PPath, Selector<X3PSelector>>(){

            @Override
            public Selector<X3PSelector> apply(X3PPath x) {
                return ContentFilter.within(x);
            }
        }));
    }

    private static Selector<X3PSelector> within(final X3PPath path) {
        return new Selector<X3PSelector>(){

            @Override
            public Boolean apply(X3PSelector x) {
                if (x instanceof X3PElement) {
                    return ((X3PElement)x).getPath().within(path);
                }
                if (x instanceof X3PPath) {
                    return ((X3PPath)x).within(path);
                }
                return Boolean.FALSE;
            }
        };
    }
}

