/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Text;

public abstract class URLEncoding {
    private URLEncoding() {
    }

    public static String decode(String text) {
        try {
            return URLDecoder.decode(text, Text.defaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static String encode(String text) {
        try {
            return URLEncoder.encode(text, Text.defaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static String encodePath(String path) {
        StringBuilder b = new StringBuilder();
        StringTokenizer st = new StringTokenizer(path, "/@", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (URLEncoding.isDelimiter(token)) {
                b.append(token);
                continue;
            }
            b.append(URLEncoding.encodePathSegment(token));
        }
        return b.toString();
    }

    private static String encodePathSegment(String segment) {
        return URLEncoding.encode(segment).replace("+", "%20");
    }

    private static boolean isDelimiter(String token) {
        return "/".equals(token) || "@".equals(token);
    }
}

