/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.concurrent.TimeUnit;

public class TimeDuration
implements Comparable<TimeDuration> {
    private final long duration;
    private final TimeUnit unit;

    public TimeDuration(long duration, TimeUnit unit) {
        this.unit = unit;
        this.duration = duration;
    }

    public TimeDuration(String duration, TimeUnit unit) {
        this(Long.parseLong(duration), unit);
    }

    @Override
    public int compareTo(TimeDuration o) {
        long other = this.unit.convert(o.duration(), o.unit());
        if (this.duration < other) {
            return -1;
        }
        if (this.duration == other) {
            return 0;
        }
        return 1;
    }

    public long duration() {
        return this.duration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeDuration other = (TimeDuration)obj;
        long otherDuration = this.unit.convert(other.duration(), other.unit());
        return this.duration == otherDuration;
    }

    public boolean exceeded(long start, long end) {
        long expectedEnd = start + TimeUnit.MILLISECONDS.convert(this.duration, this.unit);
        return end > expectedEnd;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Long.toString(this.duration));
        switch (this.unit) {
            case DAYS: {
                builder.append('d');
                break;
            }
            case HOURS: {
                builder.append('h');
                break;
            }
            case MINUTES: {
                builder.append('m');
                break;
            }
            case SECONDS: {
                builder.append('s');
                break;
            }
            case MILLISECONDS: {
                builder.append("ms");
                break;
            }
            case MICROSECONDS: {
                builder.append("us");
                break;
            }
            case NANOSECONDS: {
                builder.append("ns");
            }
        }
        return builder.toString();
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public static TimeDuration parse(String text) {
        TimeUnit unit = TimeUnit.SECONDS;
        if (text.length() == 0) {
            throw new IllegalArgumentException(text);
        }
        int end = text.length();
        if (text.length() > 1) {
            --end;
            char[] suffix = text.substring(text.length() - 2, text.length()).toCharArray();
            char lastChar = suffix[1];
            char secondLastChar = suffix[0];
            block0 : switch (lastChar) {
                case 'd': {
                    unit = TimeUnit.DAYS;
                    break;
                }
                case 'h': {
                    unit = TimeUnit.HOURS;
                    break;
                }
                case 'm': {
                    unit = TimeUnit.MINUTES;
                    break;
                }
                case 's': {
                    switch (secondLastChar) {
                        case 'm': {
                            unit = TimeUnit.MILLISECONDS;
                            --end;
                            break block0;
                        }
                        case 'u': {
                            unit = TimeUnit.MICROSECONDS;
                            --end;
                            break block0;
                        }
                        case 'n': {
                            unit = TimeUnit.NANOSECONDS;
                            --end;
                            break block0;
                        }
                    }
                    unit = TimeUnit.SECONDS;
                    break;
                }
                default: {
                    end = text.length();
                    unit = TimeUnit.SECONDS;
                }
            }
        }
        long duration = Long.parseLong(text.substring(0, end));
        return new TimeDuration(duration, unit);
    }
}

