/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterators;

public final class NSContext
implements NamespaceContext {
    private final AssociativeArray<String, String> namespaces;
    private final AssociativeArray<String, String> prefixes;

    private NSContext(AssociativeArray<String, String> namespaces) {
        this.namespaces = namespaces;
        AssociativeArrays.Builder prefixes = AssociativeArrays.builder();
        for (String prefix : namespaces) {
            String namespace = namespaces.get(prefix);
            prefixes.add(prefix, namespace);
        }
        this.prefixes = prefixes.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NSContext other = (NSContext)obj;
        return !(this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces));
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.prefixes.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        String prefix = this.getPrefix(namespaceURI);
        if (prefix == null) {
            return Iterators.empty();
        }
        return Iterators.iterator(prefix);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespaces == null ? 0 : this.namespaces.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NSContext [namespaces=");
        builder.append(this.namespaces);
        builder.append("]");
        return builder.toString();
    }

    public static NSContext namespaceContext(String ... nsPairs) {
        return new NSContext(AssociativeArrays.asArray(nsPairs));
    }
}

