/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;

public abstract class MultiAssociativeArrays {
    private static MultiAssociativeArray<Object, Object> EMPTY = MultiAssociativeArrays.builder().build();

    private MultiAssociativeArrays() {
    }

    public static <K, V> MultiAssociativeArray<K, V> array(AssociativeArray<K, V> values) {
        if (values instanceof MultiAssociativeArray) {
            return (MultiAssociativeArray)values;
        }
        return new FromArray(values);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> MultiAssociativeArray<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> MultiAssociativeArray<K, V> fromMap(Map<K, V[]> map) {
        Builder<K, V> b = MultiAssociativeArrays.builder();
        for (K key : map.keySet()) {
            V[] values;
            for (V value : values = map.get(key)) {
                b.add(key, value);
            }
        }
        return b.build();
    }

    public static <K, V> Serializer<K, V> serializer() {
        return new ObjectSerializer();
    }

    public static Serializer<String, String> stringSerializer() {
        return new StringSerializer();
    }

    public static <K, V> void write(OutputStream out, MultiAssociativeArray<K, V> values) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        int numKeys = values.size();
        oos.writeInt(numKeys);
        for (Object key : values) {
            oos.writeObject(key);
            Iterable<V> items = values.values(key);
            int size = Iterables.size(items);
            oos.writeInt(size);
            for (V item : items) {
                oos.writeObject(item);
            }
        }
        oos.flush();
    }

    private static <K, V> MultiAssociativeArray<K, V> array(K key, V value) {
        return MultiAssociativeArrays.builder().add(key, value).build();
    }

    private static class StringSerializer
    extends SerializerBase<String, String> {
        private StringSerializer() {
        }

        @Override
        protected String readKey(ObjectInputStream input) throws IOException, ClassNotFoundException {
            return input.readUTF();
        }

        @Override
        protected String readValue(ObjectInputStream input) throws IOException, ClassNotFoundException {
            return input.readUTF();
        }

        @Override
        protected void writeKey(ObjectOutputStream output, String key) throws IOException {
            output.writeUTF(key);
        }

        @Override
        protected void writeValue(ObjectOutputStream output, String value) throws IOException {
            output.writeUTF(value);
        }
    }

    private static class Replaced<K, V>
    extends Base<K, V> {
        private final MultiAssociativeArray<K, V> existing;
        private final MultiAssociativeArray<K, V> replaced;

        private Replaced(MultiAssociativeArray<K, V> existing, MultiAssociativeArray<K, V> replaced) {
            this.existing = existing;
            this.replaced = replaced;
        }

        @Override
        public V get(Object key) {
            return Iterables.first(this.values(key));
        }

        @Override
        public Iterator<K> iterator() {
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.existing);
            Iterables.add(keys, this.replaced);
            return keys.iterator();
        }

        @Override
        public int size() {
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.existing);
            Iterables.add(keys, this.replaced);
            return keys.size();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            Iterable<Pair<K, V>> values = this.replaced.values();
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this.existing.values();
            }
            ArrayList<Pair<K, V>> replaced = new ArrayList<Pair<K, V>>();
            for (K key : this) {
                Iterable<V> replacedValues = this.replaced.values(key);
                if (replacedValues == null) {
                    replacedValues = this.existing.values(key);
                }
                for (V value : replacedValues) {
                    replaced.add(Pair.pair(key, value));
                }
            }
            return replaced;
        }

        @Override
        public Iterable<V> values(Object key) {
            Iterable<V> values = this.replaced.values(key);
            if (values != null) {
                return values;
            }
            return this.existing.values(key);
        }
    }

    private static class Removed<K, V>
    extends Base<K, V> {
        private final MultiAssociativeArray<K, V> existing;
        private final MultiAssociativeArray<K, V> removed;

        private Removed(MultiAssociativeArray<K, V> existing, MultiAssociativeArray<K, V> removed) {
            this.existing = existing;
            this.removed = removed;
        }

        @Override
        public V get(Object key) {
            V value = this.removed.get(key);
            if (value == null) {
                return this.existing.get(key);
            }
            return null;
        }

        @Override
        public Iterator<K> iterator() {
            Iterator<Pair<K, V>> values = this.values().iterator();
            return Iterators.transform(values, new Transform<Pair<K, V>, K>(){

                @Override
                public K apply(Pair<K, V> x) {
                    return x.first();
                }
            });
        }

        @Override
        public int size() {
            return Iterables.size(this.values());
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            Iterable<Pair<K, V>> values = this.removed.values();
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this.existing.values();
            }
            ArrayList<Pair<K, V>> removed = new ArrayList<Pair<K, V>>();
            Iterables.add(removed, this.existing.values());
            for (Pair<K, V> pair : values) {
                removed.remove(pair);
            }
            return removed;
        }

        @Override
        public Iterable<V> values(Object key) {
            Iterable<V> values = this.removed.values(key);
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this.existing.values(key);
            }
            ArrayList removed = new ArrayList();
            Iterables.add(removed, this.existing.values(key));
            for (V value : values) {
                removed.remove(value);
            }
            return removed;
        }
    }

    private static class ObjectSerializer<K, V>
    extends SerializerBase<K, V> {
        private ObjectSerializer() {
        }

        @Override
        protected K readKey(ObjectInputStream input) throws IOException, ClassNotFoundException {
            Object key;
            Object k = key = input.readObject();
            return (K)k;
        }

        @Override
        protected V readValue(ObjectInputStream input) throws IOException, ClassNotFoundException {
            Object value;
            Object v = value = input.readObject();
            return (V)v;
        }

        @Override
        protected void writeKey(ObjectOutputStream output, K key) throws IOException {
            output.writeObject(key);
        }

        @Override
        protected void writeValue(ObjectOutputStream output, V value) throws IOException {
            output.writeObject(value);
        }
    }

    private static class Merged<K, V>
    extends Base<K, V> {
        private final MultiAssociativeArray<K, V> child;
        private final MultiAssociativeArray<K, V> parent;

        private Merged(MultiAssociativeArray<K, V> child, MultiAssociativeArray<K, V> parent) {
            this.child = child;
            this.parent = parent;
        }

        @Override
        public V get(Object key) {
            return Iterables.first(this.values(key));
        }

        @Override
        public Iterator<K> iterator() {
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.parent);
            Iterables.add(keys, this.child);
            return keys.iterator();
        }

        @Override
        public int size() {
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.parent);
            Iterables.add(keys, this.child);
            return keys.size();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            LinkedHashSet<Pair<K, V>> values = new LinkedHashSet<Pair<K, V>>();
            Iterables.add(values, this.parent.values());
            Iterables.add(values, this.child.values());
            return values;
        }

        @Override
        public Iterable<V> values(Object key) {
            LinkedHashSet values = new LinkedHashSet();
            Iterables.add(values, this.parent.values(key));
            Iterables.add(values, this.child.values(key));
            return new ArrayList(values);
        }
    }

    private static class Impl<K, V>
    extends Base<K, V> {
        private final Map<K, List<V>> byKey;
        private final Set<Pair<K, V>> values;

        private Impl(Map<K, List<V>> byKey, Set<Pair<K, V>> values) {
            this.byKey = byKey;
            this.values = values;
        }

        @Override
        public Iterator<K> iterator() {
            return this.byKey.keySet().iterator();
        }

        @Override
        public int size() {
            return this.byKey.size();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            return this.values;
        }

        @Override
        public Iterable<V> values(Object key) {
            return this.byKey.get(key);
        }
    }

    private static class FromArray<K, V>
    extends Base<K, V> {
        private final AssociativeArray<K, V> values;

        private FromArray(AssociativeArray<K, V> values) {
            this.values = values;
        }

        @Override
        public V get(Object key) {
            return this.values.get(key);
        }

        @Override
        public Iterator<K> iterator() {
            return this.values.iterator();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            ArrayList<Pair<K, V>> values = new ArrayList<Pair<K, V>>();
            for (K key : this.values) {
                V value = this.values.get(key);
                values.add(Pair.pair(key, value));
            }
            return values;
        }

        @Override
        public Iterable<V> values(Object key) {
            return Arrays.asList(this.get(key));
        }
    }

    public static abstract class SerializerBase<K, V>
    implements Serializer<K, V> {
        @Override
        public MultiAssociativeArray<K, V> read(InputStream in) throws IOException, ClassNotFoundException {
            Builder<K, V> values = MultiAssociativeArrays.builder();
            ObjectInputStream ois = new ObjectInputStream(in);
            int numKeys = ois.readInt();
            for (int i = 0; i < numKeys; ++i) {
                K k = this.readKey(ois);
                int size = ois.readInt();
                for (int j = 0; j < size; ++j) {
                    V v = this.readValue(ois);
                    values.add(k, v);
                }
            }
            return values.build();
        }

        @Override
        public void write(OutputStream out, MultiAssociativeArray<K, V> values) throws IOException {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            int numKeys = values.size();
            oos.writeInt(numKeys);
            for (Object key : values) {
                this.writeKey(oos, key);
                Iterable<V> items = values.values(key);
                int size = Iterables.size(items);
                oos.writeInt(size);
                for (V item : items) {
                    if (item == null) {
                        throw new NullPointerException(key.toString());
                    }
                    this.writeValue(oos, item);
                }
            }
            oos.flush();
        }

        protected abstract K readKey(ObjectInputStream var1) throws IOException, ClassNotFoundException;

        protected abstract V readValue(ObjectInputStream var1) throws IOException, ClassNotFoundException;

        protected abstract void writeKey(ObjectOutputStream var1, K var2) throws IOException;

        protected abstract void writeValue(ObjectOutputStream var1, V var2) throws IOException;
    }

    public static interface Serializer<K, V> {
        public MultiAssociativeArray<K, V> read(InputStream var1) throws IOException, ClassNotFoundException;

        public void write(OutputStream var1, MultiAssociativeArray<K, V> var2) throws IOException;
    }

    public static class Builder<K, V> {
        private final Map<K, List<V>> byKey = new LinkedHashMap<K, List<V>>();
        private final Set<Pair<K, V>> values = new LinkedHashSet<Pair<K, V>>();

        private Builder() {
        }

        public Builder<K, V> add(K key, V value) {
            if (this.values.add(Pair.pair(key, value))) {
                List<V> values = this.byKey.get(key);
                if (values == null) {
                    values = new ArrayList<V>();
                    this.byKey.put(key, values);
                }
                values.add(value);
            }
            return this;
        }

        public Builder<K, V> add(MultiAssociativeArray<K, V> values) {
            for (Object key : values) {
                Iterable<V> keyValues = values.values(key);
                for (V value : keyValues) {
                    this.add(key, value);
                }
            }
            return this;
        }

        public MultiAssociativeArray<K, V> build() {
            return new Impl(this.byKey, this.values);
        }

        public boolean contains(K key, V value) {
            List<V> values = this.byKey.get(key);
            if (values == null) {
                return false;
            }
            return values.contains(value);
        }

        public Builder<K, V> remove(K key) {
            if (this.byKey.remove(key) != null) {
                Iterator<Pair<K, V>> values = this.values.iterator();
                while (values.hasNext()) {
                    Pair<K, V> pair = values.next();
                    if (!key.equals(pair.first())) continue;
                    values.remove();
                }
            }
            return this;
        }

        public Builder<K, V> set(K key, V value) {
            return this.remove(key).add(key, value);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.values);
            return builder.toString();
        }
    }

    public static abstract class Base<K, V>
    extends AssociativeArrays.Base<K, V>
    implements MultiAssociativeArray<K, V> {
        @Override
        public V get(Object key) {
            return Iterables.first(this.values(key));
        }

        @Override
        public MultiAssociativeArray<K, V> put(AssociativeArray<K, V> values) {
            return new Merged(MultiAssociativeArrays.array(values), this);
        }

        @Override
        public MultiAssociativeArray<K, V> put(K key, V value) {
            return this.put((AssociativeArray)MultiAssociativeArrays.array(key, value));
        }

        @Override
        public MultiAssociativeArray<K, V> remove(K key) {
            Iterable values = this.values(key);
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this;
            }
            Builder b = MultiAssociativeArrays.builder();
            for (Object value : values) {
                b.add(key, value);
            }
            return this.remove(b.build());
        }

        @Override
        public MultiAssociativeArray<K, V> remove(K key, V value) {
            return this.remove(MultiAssociativeArrays.array(key, value));
        }

        @Override
        public MultiAssociativeArray<K, V> remove(MultiAssociativeArray<K, V> toRemove) {
            return new Removed(this, toRemove);
        }

        @Override
        public MultiAssociativeArray<K, V> replace(K key, V value) {
            return this.replace(MultiAssociativeArrays.array(key, value));
        }

        @Override
        public MultiAssociativeArray<K, V> replace(MultiAssociativeArray<K, V> toReplace) {
            return new Replaced(this, toReplace);
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{");
            b.append(Iterables.join(Iterables.transform(this, new Transform<K, String>(){

                @Override
                public String apply(K key) {
                    StringBuilder b = new StringBuilder();
                    Iterable values = Base.this.values(key);
                    b.append(key);
                    b.append("=[");
                    b.append(Iterables.join(values, ", "));
                    b.append("]");
                    return b.toString();
                }
            }), ", "));
            b.append("}");
            return b.toString();
        }
    }
}

