/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Arrays;
import oracle.dbtools.common.util.CharacterClass;

public abstract class CharacterClasses {
    private CharacterClasses() {
    }

    public static CharacterClass group(CharacterClass ... classes) {
        return new CharacterClassGroup(classes);
    }

    public static CharacterClass literal(int literal) {
        return CharacterClasses.literals(literal);
    }

    public static CharacterClass literals(int ... characters) {
        return new LiteralCharacterClass(characters);
    }

    public static CharacterClass range(int start, int end) {
        return new CharacterClassRange(end, start);
    }

    private static final class CharacterClassRange
    implements CharacterClass {
        private final int end;
        private final int start;

        CharacterClassRange(int end, int start) {
            this.end = end;
            this.start = start;
        }

        @Override
        public boolean matches(int c) {
            return c >= this.start && c <= this.end;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CharacterClassRange [end=");
            builder.append(this.end);
            builder.append(", start=");
            builder.append(this.start);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class CharacterClassGroup
    implements CharacterClass {
        private final CharacterClass[] classes;

        CharacterClassGroup(CharacterClass[] classes) {
            this.classes = classes;
        }

        @Override
        public boolean matches(int c) {
            for (int i = 0; i < this.classes.length; ++i) {
                if (!this.classes[i].matches(c)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CharacterClassGroup [classes=");
            builder.append(Arrays.toString(this.classes));
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class LiteralCharacterClass
    implements CharacterClass {
        private final int[] characters;

        LiteralCharacterClass(int[] characters) {
            this.characters = characters;
        }

        @Override
        public boolean matches(int c) {
            for (int i = 0; i < this.characters.length; ++i) {
                if (c != this.characters[i]) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LiteralCharacterClass [characters=");
            builder.append(Arrays.toString(this.characters));
            builder.append("]");
            return builder.toString();
        }
    }
}

