/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;

public class ChangeSet<T>
implements Iterable<T> {
    private final Selector<T> added = new Selector<T>(){

        @Override
        public Boolean apply(T item) {
            return !ChangeSet.this.initial.contains(item);
        }
    };
    private final Set<T> initial = new LinkedHashSet<T>();
    private final Selector<T> maintained = Selectors.not(this.added);
    private final Set<T> modified = new LinkedHashSet<T>();
    private final Selector<T> removed = new Selector<T>(){

        @Override
        public Boolean apply(T item) {
            return !ChangeSet.this.modified.contains(item);
        }
    };

    private ChangeSet(Iterable<T> initialSet) {
        Iterables.add(this.initial, initialSet);
    }

    public Iterable<T> added() {
        return Iterables.select(this.modified, this.added);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeSet other = (ChangeSet)obj;
        return !(this.modified == null ? other.modified != null : !this.modified.equals(other.modified));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modified == null ? 0 : this.modified.hashCode());
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.modified.iterator();
    }

    public Iterable<T> maintained() {
        return Iterables.select(this.modified, this.maintained);
    }

    public ChangeSet<T> modified(T ... items) {
        Iterables.add(this.modified, Iterables.iterable(items));
        return this;
    }

    public ChangeSet<T> modified(T item) {
        this.modified.add(item);
        return this;
    }

    public Iterable<T> removed() {
        return Iterables.select(this.initial, this.removed);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChangeSet [added()=");
        builder.append(Iterables.join(this.added(), ", "));
        builder.append(", maintained()=");
        builder.append(Iterables.join(this.maintained(), ", "));
        builder.append(", removed()=");
        builder.append(Iterables.join(this.removed(), ", "));
        builder.append("]");
        return builder.toString();
    }

    public static <T> ChangeSet<T> changeSet(Iterable<T> initialSet) {
        return new ChangeSet<T>(initialSet);
    }
}

