/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

public abstract class CallStacks {
    private CallStacks() {
    }

    public static StackTraceElement caller(int callerStackDepth) {
        if (callerStackDepth < 0) {
            throw new IllegalArgumentException();
        }
        long offset = (long)callerStackDepth + 1L;
        Throwable t = new Throwable();
        StackTraceElement[] callStack = t.getStackTrace();
        if (offset < (long)callStack.length) {
            StackTraceElement methodCaller = callStack[(int)offset];
            return methodCaller;
        }
        return null;
    }

    public static StackTraceElement caller(Class<?> ... callerOfType) {
        Throwable t = new Throwable();
        StackTraceElement[] callStack = t.getStackTrace();
        for (int i = 1; i < callStack.length; ++i) {
            StackTraceElement caller = callStack[i];
            if (CallStacks.isCaller(caller, callerOfType)) continue;
            return caller;
        }
        return null;
    }

    private static boolean isCaller(StackTraceElement caller, Class<?>[] callerOfType) {
        for (Class<?> type : callerOfType) {
            if (!type.getName().equals(caller.getClassName())) continue;
            return true;
        }
        return false;
    }
}

