/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.dbtools.common.util.IteratorState;

public abstract class AbstractIterator<T>
implements Iterator<T>,
IteratorState {
    private boolean raiseNoSuchElement;
    private T item;
    private int nextCount = 0;
    private final boolean nullIndicatesEnd;
    private boolean finished = false;
    private boolean started = false;

    protected AbstractIterator() {
        this(true, false);
    }

    protected AbstractIterator(boolean nullIndicatesEnd) {
        this(nullIndicatesEnd, false);
    }

    protected AbstractIterator(boolean nullIndicatesEnd, boolean raiseNoSuchElement) {
        this.nullIndicatesEnd = nullIndicatesEnd;
        this.raiseNoSuchElement = raiseNoSuchElement;
    }

    @Override
    public final boolean beforeNext() {
        return 0 == this.nextCount;
    }

    @Override
    public final boolean hasNext() {
        this.start();
        return !this.finished;
    }

    @Override
    public final T next() {
        this.start();
        if (this.raiseNoSuchElement && this.finished) {
            throw new NoSuchElementException();
        }
        if (!this.finished) {
            ++this.nextCount;
        }
        T next = this.item;
        this.item = this._advance();
        return next;
    }

    @Override
    @Deprecated
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract T advance();

    protected final T eos() {
        this.finished = true;
        return null;
    }

    private final T _advance() {
        T item = this.advance();
        if (item == null && this.nullIndicatesEnd) {
            return this.eos();
        }
        return item;
    }

    private void start() {
        if (!this.started) {
            this.item = this._advance();
            this.started = true;
        }
    }

    protected int nextCount() {
        return this.nextCount;
    }
}

