/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.tash;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.resources.Resource;
import oracle.dbtools.common.resources.Resources;
import oracle.dbtools.common.resources.ResourcesContainer;
import oracle.dbtools.common.tash.TashTemplate;
import oracle.dbtools.common.tash.TashTemplates;
import oracle.dbtools.common.tash.TashTemplatesProvider;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.IOStreamsProvider;
import oracle.dbtools.common.util.Lookup;
import oracle.dbtools.plugin.api.io.IOStreams;
import oracle.dbtools.plugin.api.logging.Log;

public class TashResources {
    private final Log log;
    private final Lookup<TashTemplate> partials;
    private final IOStreams streams;
    private final Resources templateResources;
    private final TashTemplates templates;
    private static final IOStreams STREAMS = new IOStreamsProvider();
    private static final TashTemplates TEMPLATES = new TashTemplatesProvider();

    public TashResources(Log log, IOStreams streams, TashTemplates templates, Resources templateResources) {
        this(log, streams, templates, templateResources, TashResources.partials(log, streams, templates, templateResources, "_partials"));
    }

    public TashResources(Log log, IOStreams streams, TashTemplates templates, Resources templateResources, Lookup<TashTemplate> partials) {
        this.log = log;
        this.streams = streams;
        this.templates = templates;
        this.templateResources = templateResources;
        this.partials = partials;
    }

    public TashResources(Log log, Resources templateResources) {
        this(log, STREAMS, TEMPLATES, templateResources);
    }

    public TashTemplate template(String path) throws IOException {
        Resource resource = this.templateResources.get(path);
        if (resource == null) {
            this.log.warning("Could not find template named: " + path);
            return null;
        }
        return TashResources.tashTemplate(this.streams, this.templates, this.partials, resource);
    }

    private static Lookup<TashTemplate> partials(Log log, IOStreams streams, TashTemplates templates, Resources resources, String subFolder) {
        ResourcesContainer partials = ResourcesContainer.builder(resources).base(subFolder).build();
        return new PartialResources(streams, partials, log, templates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TashTemplate tashTemplate(IOStreams streams, TashTemplates templates, Lookup<TashTemplate> partials, Resource resource) throws IOException {
        InputStream content = resource.inputStream();
        try {
            TashTemplate template;
            String text = streams.asString(content);
            TashTemplate tashTemplate = template = templates.template(text, partials);
            return tashTemplate;
        }
        finally {
            Closeables.close(content);
        }
    }

    private static final class PartialResources
    implements Lookup<TashTemplate> {
        private final Log log;
        private final Resources partials;
        private final IOStreams streams;
        private final TashTemplates templates;

        private PartialResources(IOStreams streams, Resources partials, Log log, TashTemplates templates) {
            this.streams = streams;
            this.partials = partials;
            this.log = log;
            this.templates = templates;
        }

        @Override
        public TashTemplate get(Object key) {
            Resource resource = (Resource)this.partials.get(key);
            if (resource == null) {
                this.log.warning("Could not find a partial named: " + key);
                return null;
            }
            try {
                return TashResources.tashTemplate(this.streams, this.templates, null, resource);
            }
            catch (IOException e) {
                this.log.severe((Throwable)e);
                return null;
            }
        }
    }
}

