/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service.properties;

import oracle.dbtools.common.di.ServiceSelectors;
import oracle.dbtools.common.service.properties.Properties;
import oracle.dbtools.common.service.properties.Property;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Selector;

public abstract class PropertySelectors {
    private PropertySelectors() {
    }

    public static ServiceSelectors.ServiceSelectorBuilder has(ServiceSelectors.ServiceSelectorBuilder selectors, AssociativeArray<String, String> properties) {
        selectors.and(new HasProperties(properties));
        return selectors;
    }

    public static ServiceSelectors.ServiceSelectorBuilder has(ServiceSelectors.ServiceSelectorBuilder selectors, String propertyName) {
        selectors.and(new HasPropertyNamed(propertyName));
        return selectors;
    }

    public static AssociativeArray<String, String> properties(Class<?> type) {
        Properties propertiesDef = type.getAnnotation(Properties.class);
        if (propertiesDef == null) {
            return AssociativeArrays.empty();
        }
        Property[] props = propertiesDef.value();
        AssociativeArrays.Builder properties = AssociativeArrays.builder();
        for (Property p : props) {
            properties.add(p.name(), p.value());
        }
        return properties.build();
    }

    public static class HasPropertyNamed
    implements Selector<Class<?>> {
        private final String propertyName;

        public HasPropertyNamed(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public Boolean apply(Class<?> type) {
            AssociativeArray<String, String> properties = PropertySelectors.properties(type);
            return properties.get(this.propertyName) != null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HasPropertyNamed [propertyName=");
            builder.append(this.propertyName);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class HasProperties
    implements Selector<Class<?>> {
        private final AssociativeArray<String, String> properties;

        HasProperties(AssociativeArray<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public Boolean apply(Class<?> type) {
            AssociativeArray<String, String> properties = PropertySelectors.properties(type);
            return AssociativeArrays.contains(properties, this.properties);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HasProperties [properties=");
            builder.append(this.properties);
            builder.append("]");
            return builder.toString();
        }
    }
}

