/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.Provider;
import oracle.dbtools.common.service.Providers;
import oracle.dbtools.common.service.ServiceLocatorException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.__Reflections;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;

public abstract class ServiceLocator {
    private static final WeakHashMap<Class<?>, Object> INSTANCES = new WeakHashMap();
    private static final String[] NO_PROPERTIES = new String[0];
    private static final Map<Class<?>, Providers> SERVICES = new HashMap();
    private static final Log LOG = Log.get(ServiceLocator.class);

    private ServiceLocator() {
    }

    public static <T> T acquire(Class<T> service) {
        return ServiceLocator.acquire(service, NO_PROPERTIES);
    }

    public static <T> T acquire(Class<T> service, Map<String, String> properties) {
        Iterable<T> providers = ServiceLocator.acquireAll(service, properties);
        if (Iterables.empty().equals(providers)) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "ServiceLocator.0", "No provider found for: {0}", service.getName()), null);
        }
        return ServiceLocator.first(providers);
    }

    public static <T> T acquire(Class<T> service, String ... propertyPairs) {
        Map<String, String> properties = ServiceLocator.toMap(propertyPairs);
        return ServiceLocator.acquire(service, properties);
    }

    public static <T> Iterable<T> acquireAll(Class<T> service, Map<String, String> properties) {
        Providers p = SERVICES.get(service);
        if (p == null) {
            return Collections.emptyList();
        }
        return p.match(service, properties);
    }

    public static <T> Iterable<T> acquireAll(Class<T> service, String ... propertyPairs) {
        Map<String, String> properties = ServiceLocator.toMap(propertyPairs);
        return ServiceLocator.acquireAll(service, properties);
    }

    public static <T> void release(T ... services) {
    }

    public static void setup(Class<?> ... fixtureClasses) {
        LinkedHashSet classes = new LinkedHashSet();
        for (Class<?> fixture : fixtureClasses) {
            classes.add(fixture);
        }
        ServiceLocator.prepare(classes);
    }

    public static synchronized void setup(ClassLoader scope) throws IOException {
        LinkedHashSet services = new LinkedHashSet();
        Enumeration<URL> resources = scope.getResources("META-INF/oracle.dbtools.common.services");
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            services.addAll(ServiceLocator.load(scope, resource));
        }
        ServiceLocator.prepare(services);
        if (SERVICES.isEmpty()) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "ServiceLocator.2", "There are no services defined", new Object[0]));
        }
    }

    public static void teardown() {
        for (Providers p : SERVICES.values()) {
            p.teardown();
        }
        SERVICES.clear();
        INSTANCES.clear();
    }

    static Map<String, String> properties(Class<?> clazz) {
        Service serviceDef = __Reflections.getAnnotation(clazz, Service.class);
        Property[] props = null;
        if (serviceDef != null) {
            props = serviceDef.properties();
        }
        return ServiceLocator.properties(props);
    }

    static Map<String, String> properties(Property[] props) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property p : props) {
            properties.put(p.name(), p.value());
        }
        return properties;
    }

    public static void activateImmediates() {
        for (Providers p : SERVICES.values()) {
            p.activateImmediates();
        }
    }

    private static <T> T first(Iterable<T> values) {
        Iterator<T> iter = values.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    private static Object instantiate(Class<?> clazz) {
        String serviceName = clazz.getName();
        LOG.finest("Loading: " + serviceName);
        try {
            Object service = clazz.newInstance();
            return service;
        }
        catch (InstantiationException e) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "ServiceLocator.4", "Error instantiating: {0}", serviceName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "ServiceLocator.5", "Could not access: {0}", serviceName), (Throwable)e);
        }
    }

    private static Class<?> load(ClassLoader scope, String serviceName) {
        try {
            Class<?> clazz = scope.loadClass(serviceName);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "ServiceLocator.6", "Could not locate: {0}", serviceName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Class<?>> load(ClassLoader scope, URL resource) throws IOException {
        LinkedHashSet classes = new LinkedHashSet();
        try (BufferedReader r = null;){
            r = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));
            String service = r.readLine();
            while (service != null) {
                Class<?> type = ServiceLocator.load(scope, service);
                if (ServiceLocator.hasDefaultConstructor(type)) {
                    classes.add(type);
                }
                service = r.readLine();
            }
            LinkedHashSet linkedHashSet = classes;
            return linkedHashSet;
        }
    }

    private static boolean hasDefaultConstructor(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            LOG.finest(e);
            return false;
        }
    }

    private static void prepare(Class<?> clazz) {
        Object exists = INSTANCES.get(clazz);
        if (exists == null) {
            Service serviceDef = clazz.getAnnotation(Service.class);
            Class<?>[] provides = ServiceLocator.provides(clazz);
            boolean immediate = false;
            immediate = serviceDef == null ? true : serviceDef.immediate();
            Map<String, String> properties = ServiceLocator.properties(clazz);
            Object service = ServiceLocator.instantiate(clazz);
            INSTANCES.put(clazz, service);
            Provider provider = new Provider(service, immediate, new ServiceProperties(properties));
            for (Class<?> s : provides) {
                Providers p = SERVICES.get(s);
                if (p == null) {
                    p = new Providers(s);
                    SERVICES.put(s, p);
                }
                p.add(provider);
            }
        }
    }

    private static void prepare(Set<Class<?>> services) {
        for (Class<?> service : services) {
            ServiceLocator.prepare(service);
        }
    }

    private static Class<?>[] provides(Class<?> clazz) {
        String serviceName = clazz.getName();
        Class<?>[] provides = null;
        Service serviceDef = clazz.getAnnotation(Service.class);
        if (serviceDef == null) {
            throw new ServiceLocatorException(new TranslatableMessage(CommonMessages.class, "ServiceLocator.7", "Could not find service annotation for: {0}", serviceName), null);
        }
        provides = serviceDef.provides();
        if (provides == null || provides.length == 0) {
            provides = clazz.getInterfaces();
        }
        if (provides == null || provides.length == 0) {
            provides = new Class[]{clazz};
        }
        return provides;
    }

    private static Map<String, String> toMap(String ... propertyPairs) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < propertyPairs.length; ++i) {
            String key = propertyPairs[i];
            String value = propertyPairs[++i];
            properties.put(key, value);
        }
        return properties;
    }
}

