/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import oracle.dbtools.common.reflect.FileResourceFactory;
import oracle.dbtools.common.reflect.FilerFixture;
import oracle.dbtools.common.reflect.MemoryResourceFactory;
import oracle.dbtools.common.reflect.NameFixture;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;

class AnnotationProcessorRuntime
implements Callable<AnnotationProcessorRuntime> {
    private final MultiAssociativeArray<String, AnnotatedElement> annotatedElements;
    private final Elements elements;
    private final FilerFixture filer;
    private final Messager messager;
    private final ProcessingEnvironment processingEnvironment;
    private final Class<? extends Processor>[] processorTypes;

    public AnnotationProcessorRuntime(FileResourceFactory factory, Iterable<AnnotatedElement> elements, Class<? extends Processor> ... processorTypes) {
        this.processorTypes = processorTypes;
        this.messager = new MessagerFixture();
        this.filer = new FilerFixture(factory);
        this.elements = new ElementsFixture();
        this.processingEnvironment = new ProcessingEnvironmentFixture();
        MultiAssociativeArrays.Builder<String, AnnotatedElement> annotatedElements = MultiAssociativeArrays.builder();
        for (AnnotatedElement element : elements) {
            for (Annotation annotation : element.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                annotatedElements.add(annotationType.getName(), element);
            }
        }
        this.annotatedElements = annotatedElements.build();
    }

    public AnnotationProcessorRuntime(Iterable<AnnotatedElement> elements, Class<? extends Processor> ... processorTypes) {
        this(new MemoryResourceFactory(), elements, processorTypes);
    }

    public Set<Class<? extends Annotation>> annotationTypes() {
        LinkedHashSet<Class<? extends Annotation>> annotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
        for (Class<? extends Processor> processorType : this.processorTypes) {
            try {
                Processor processor = processorType.newInstance();
                Set<String> supportedAnnotations = processor.getSupportedAnnotationTypes();
                for (String annotation : supportedAnnotations) {
                    Class<?> type = Class.forName(annotation);
                    if (!type.isAnnotation()) continue;
                    annotationTypes.add(type);
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        return annotationTypes;
    }

    @Override
    public AnnotationProcessorRuntime call() throws Exception {
        for (Class<? extends Processor> processorType : this.processorTypes) {
            Processor processor = processorType.newInstance();
            processor.init(this.processingEnvironment);
            this.firstPass(processor);
            this.secondPass(processor);
        }
        return this;
    }

    private void firstPass(Processor processor) {
        RoundEnvironmentFixture roundEnv = new RoundEnvironmentFixture(RoundStatus.FIRST_PASS);
        this.process(roundEnv, processor);
    }

    private void process(RoundEnvironment roundEnv, Processor processor) {
        try {
            LinkedHashSet<TypeElementFixture> types = new LinkedHashSet<TypeElementFixture>();
            for (String type : processor.getSupportedAnnotationTypes()) {
                types.add(new TypeElementFixture(Class.forName(type)));
            }
            processor.process(types, roundEnv);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void secondPass(Processor processor) {
        RoundEnvironmentFixture roundEnv = new RoundEnvironmentFixture(RoundStatus.SECOND_PASS);
        this.process(roundEnv, processor);
    }

    static void unimplemented() {
        throw new UnsupportedOperationException();
    }

    private static class ConstructorFixture
    implements ExecutableElement {
        private final Constructor<?> ctor;

        public ConstructorFixture(Constructor<?> ctor) {
            this.ctor = ctor;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public TypeMirror asType() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)this.ctor.getAnnotation(annotationType);
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public AnnotationValue getDefaultValue() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Element getEnclosingElement() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        @Override
        public Set<javax.lang.model.element.Modifier> getModifiers() {
            HashSet<javax.lang.model.element.Modifier> mods = new HashSet<javax.lang.model.element.Modifier>();
            if (Modifier.isPublic(this.ctor.getModifiers())) {
                mods.add(javax.lang.model.element.Modifier.PUBLIC);
            }
            return mods;
        }

        @Override
        public List<? extends VariableElement> getParameters() {
            ArrayList<VariableElementFixture> parameters = new ArrayList<VariableElementFixture>();
            for (int i = 0; i < this.ctor.getParameterTypes().length; ++i) {
                Class<?> parameter = this.ctor.getParameterTypes()[i];
                Annotation[] annotations = this.ctor.getParameterAnnotations()[i];
                VariableElementFixture element = new VariableElementFixture(parameter, annotations);
                parameters.add(element);
            }
            return parameters;
        }

        @Override
        public TypeMirror getReturnType() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Name getSimpleName() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends TypeMirror> getThrownTypes() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public boolean isVarArgs() {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public TypeMirror getReceiverType() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public boolean isDefault() {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }
    }

    private static class VariableElementFixture
    implements VariableElement {
        private final Class<?> type;
        private final Annotation[] annotations;

        VariableElementFixture(Class<?> type, Annotation[] annotations) {
            this.type = type;
            this.annotations = annotations;
        }

        @Override
        public TypeMirror asType() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public ElementKind getKind() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Set<javax.lang.model.element.Modifier> getModifiers() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Name getSimpleName() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Element getEnclosingElement() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Object getConstantValue() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }
    }

    private static class TypeElementFixture
    implements TypeElement {
        private final Class<?> type;

        public TypeElementFixture(Class<?> type) {
            this.type = type;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public TypeMirror asType() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeElementFixture other = (TypeElementFixture)obj;
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            ArrayList<ConstructorFixture> elements = new ArrayList<ConstructorFixture>();
            for (Constructor<?> ctor : this.type.getDeclaredConstructors()) {
                elements.add(new ConstructorFixture(ctor));
            }
            return elements;
        }

        @Override
        public Element getEnclosingElement() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public ElementKind getKind() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Set<javax.lang.model.element.Modifier> getModifiers() {
            HashSet<javax.lang.model.element.Modifier> modifiers = new HashSet<javax.lang.model.element.Modifier>();
            if (Modifier.isPublic(this.type.getModifiers())) {
                modifiers.add(javax.lang.model.element.Modifier.PUBLIC);
            }
            return modifiers;
        }

        @Override
        public NestingKind getNestingKind() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Name getQualifiedName() {
            return new NameFixture(this.type.getName());
        }

        @Override
        public Name getSimpleName() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public TypeMirror getSuperclass() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TypeElementFixture [type=");
            builder.append(this.type);
            builder.append("]");
            return builder.toString();
        }
    }

    private class RoundEnvironmentFixture
    implements RoundEnvironment {
        private final RoundStatus status;

        private RoundEnvironmentFixture(RoundStatus status) {
            this.status = status;
        }

        @Override
        public boolean errorRaised() {
            return false;
        }

        @Override
        public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
            String typeName = a.getName();
            return this.annotatedElements(typeName);
        }

        @Override
        public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
            String typeName = a.getQualifiedName().toString();
            return this.annotatedElements(typeName);
        }

        @Override
        public Set<? extends Element> getRootElements() {
            return Collections.emptySet();
        }

        @Override
        public boolean processingOver() {
            return RoundStatus.SECOND_PASS == this.status;
        }

        private Element adapt(AnnotatedElement match) {
            if (match instanceof Package) {
                return new PackageElementFixture((Package)match);
            }
            if (match instanceof Class) {
                return new TypeElementFixture((Class)match);
            }
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        private Set<? extends Element> annotatedElements(String typeName) {
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            Iterable matches = AnnotationProcessorRuntime.this.annotatedElements.values(typeName);
            if (matches != null) {
                for (AnnotatedElement match : matches) {
                    Element element = this.adapt(match);
                    elements.add(element);
                }
            }
            return elements;
        }
    }

    private class ProcessingEnvironmentFixture
    implements ProcessingEnvironment {
        private ProcessingEnvironmentFixture() {
        }

        @Override
        public Elements getElementUtils() {
            return AnnotationProcessorRuntime.this.elements;
        }

        @Override
        public Filer getFiler() {
            return AnnotationProcessorRuntime.this.filer;
        }

        @Override
        public Locale getLocale() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Messager getMessager() {
            return AnnotationProcessorRuntime.this.messager;
        }

        @Override
        public Map<String, String> getOptions() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public SourceVersion getSourceVersion() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Types getTypeUtils() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }
    }

    private static class PackageElementFixture
    implements PackageElement {
        private final Package pkg;

        public PackageElementFixture(Package pkg) {
            this.pkg = pkg;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public TypeMirror asType() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageElementFixture other = (PackageElementFixture)obj;
            return !(this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg));
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Element getEnclosingElement() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public ElementKind getKind() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Set<javax.lang.model.element.Modifier> getModifiers() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Name getQualifiedName() {
            return new NameFixture(this.pkg.getName());
        }

        @Override
        public Name getSimpleName() {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
            return result;
        }

        @Override
        public boolean isUnnamed() {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PackageElementFixture [pkg=");
            builder.append(this.pkg);
            builder.append("]");
            return builder.toString();
        }
    }

    private class MessagerFixture
    implements Messager {
        private MessagerFixture() {
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
            System.out.println(msg);
            if (Diagnostic.Kind.ERROR == kind) {
                throw new IllegalStateException(msg.toString());
            }
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
            AnnotationProcessorRuntime.unimplemented();
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
            AnnotationProcessorRuntime.unimplemented();
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
            AnnotationProcessorRuntime.unimplemented();
        }
    }

    private class ElementsFixture
    implements Elements {
        private ElementsFixture() {
        }

        @Override
        public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public List<? extends Element> getAllMembers(TypeElement type) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Name getBinaryName(TypeElement type) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public String getConstantExpression(Object value) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public String getDocComment(Element e) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public Name getName(CharSequence cs) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public PackageElement getPackageElement(CharSequence name) {
            return new PackageElementFixture(Package.getPackage(name.toString()));
        }

        @Override
        public PackageElement getPackageOf(Element type) {
            AnnotationProcessorRuntime.unimplemented();
            return null;
        }

        @Override
        public TypeElement getTypeElement(CharSequence name) {
            try {
                return new TypeElementFixture(Class.forName(name.toString()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean hides(Element hider, Element hidden) {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }

        @Override
        public boolean isDeprecated(Element e) {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }

        @Override
        public boolean isFunctionalInterface(TypeElement type) {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }

        @Override
        public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
            AnnotationProcessorRuntime.unimplemented();
            return false;
        }

        @Override
        public void printElements(Writer w, Element ... elements) {
            AnnotationProcessorRuntime.unimplemented();
        }
    }

    static enum RoundStatus {
        FIRST_PASS,
        SECOND_PASS;

    }
}

