/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.logging;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.inject.Inject;
import oracle.dbtools.common.logging.JDKLogFormatter;
import oracle.dbtools.common.logging.LogSink;
import oracle.dbtools.plugin.api.di.annotations.ApplicationScoped;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@ApplicationScoped
@Provides(value={LogSink.class})
public class JDKLogSink
implements LogSink {
    private final Logger logger;
    private static final Formatter ORDS_FORMATTER = new JDKLogFormatter();

    @Inject
    public JDKLogSink() {
        Logger root = Logger.getLogger("oracle.dbtools");
        for (Handler h : root.getHandlers()) {
            try {
                h.setFormatter(ORDS_FORMATTER);
            }
            catch (Throwable t) {
                root.log(Level.FINEST, "Ignored error while attempting to configure ORDS Logging Formatter for: " + h.getClass(), t);
            }
        }
        this.logger = root;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void log(LogRecord lr) {
        String logName = lr.getLoggerName();
        Logger logger = Logger.getLogger(logName);
        logger.log(lr);
    }
}

