/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.install;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionFormat {
    private static final int MAX_VERSION_COMPARE = 4;

    public static String getReleaseFormat(String version) {
        String patternDot = "\\.";
        Pattern pattern = Pattern.compile(patternDot);
        Matcher matcher = pattern.matcher(version);
        int ndx = 0;
        for (int cnt = 0; cnt < 4 && matcher.find(); ++cnt) {
            ndx = matcher.start();
        }
        if (ndx >= 6) {
            return version.substring(0, ndx);
        }
        return version;
    }

    public static boolean isEarlierVersion(String sourceVersion, String targetVersion) throws Exception {
        String[] srcList = sourceVersion.split("\\.");
        String[] trgList = targetVersion.split("\\.");
        if (srcList.length < 4 || trgList.length < 4) {
            throw new Exception("The version format is invalid. sourceVersion: " + sourceVersion + " targetVersion: " + targetVersion);
        }
        for (int i = 0; i < 4; ++i) {
            int tgtNum;
            int srcNum = Integer.parseInt(srcList[i]);
            if (srcNum < (tgtNum = Integer.parseInt(trgList[i]))) {
                return true;
            }
            if (srcNum <= tgtNum) continue;
            return false;
        }
        return false;
    }
}

