/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import javax.inject.Inject;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.Sets;
import oracle.dbtools.common.immutables.impl.SetBuilder;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
class SetsProvider
implements Sets {
    @Inject
    SetsProvider() {
    }

    @Override
    public <V> ImmutableSet.Builder<V> builder() {
        return SetBuilder.newInstance(0, Ordering.INSERTION, null);
    }

    @Override
    public <V> ImmutableSet.Builder<V> builder(Iterable<V> existing) {
        int size = Iterables.size(existing);
        return SetBuilder.newInstance(size, Ordering.INSERTION, null).add((Iterable)existing);
    }

    @Override
    public <V> ImmutableSet<V> empty() {
        return this.builder().build();
    }

    @Override
    public <V> ImmutableSet<V> set(Iterable<V> elements) {
        return this.builder(elements).build();
    }

    @Override
    public <V> ImmutableSet<V> set(V ... elements) {
        return this.set(Iterables.iterable(elements));
    }
}

