/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.headers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.headers.EncodedValue;
import oracle.dbtools.common.headers.HeaderValueScanner;
import oracle.dbtools.common.headers.HttpCharacterClasses;
import oracle.dbtools.common.headers.QuotedStringScanner;
import oracle.dbtools.common.headers.QuotedStringValue;
import oracle.dbtools.common.headers.RFC5987Value;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.common.util.NullOrEmpty;

public class HttpHeaderValue
extends CharSequenceMixin {
    private final Iterable<HeaderParameter> parameters;
    private static final HttpHeaderValue NO_PARAMETERS = new HttpHeaderValue(Iterables.empty());

    private HttpHeaderValue(Iterable<HeaderParameter> parameters) {
        super(Iterables.join(parameters, "; "));
        this.parameters = parameters;
    }

    public Map<CharSequence, CharSequence> asMap() {
        LinkedHashMap<CharSequence, CharSequence> parameters = new LinkedHashMap<CharSequence, CharSequence>();
        for (HeaderParameter param : this.parameters) {
            parameters.put(param.name(), param.value());
        }
        return parameters;
    }

    public boolean contains(ParameterType parameterType, CharSequence parameterName) {
        String expectedName = parameterName.toString();
        for (HeaderParameter param : this.parameters) {
            String actualName = param.name().toString();
            if (!expectedName.equals(actualName) || parameterType != param.type()) continue;
            return true;
        }
        return false;
    }

    public Iterable<HeaderParameter> parameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpHeaderValue parse(CharSequence text) {
        if (NullOrEmpty.nullOrEmpty(text)) {
            return NO_PARAMETERS;
        }
        Builder parameters = HttpHeaderValue.builder();
        HeaderValueScanner segments = new HeaderValueScanner(text);
        for (String segment : segments) {
            for (HeaderParameter parameter : new SegmentScanner(segment)) {
                parameters.add(parameter);
            }
        }
        return parameters.build();
    }

    private static String decodeExtendedValue(String value) {
        return RFC5987Value.decode(value).content().toString();
    }

    private static CharSequence encodeToken(CharSequence text) {
        if (text == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (HttpCharacterClasses.TCHAR.matches(c)) {
                encoded.append(c);
                continue;
            }
            encoded.append('?');
        }
        return encoded.toString();
    }

    private static class SegmentScanner
    extends CharSequenceMixin
    implements Iterable<HeaderParameter> {
        private final QuotedStringScanner scanner;

        private SegmentScanner(CharSequence text) {
            super(text);
            this.scanner = new QuotedStringScanner(text);
        }

        @Override
        public Iterator<HeaderParameter> iterator() {
            return new HeaderParameterIterator(this.scanner.iterator());
        }
    }

    private static class HeaderParameterIterator
    extends M2NIterator<QuotedStringScanner.Token, HeaderParameter> {
        private String name;
        private ParameterType type;
        private String value;

        private HeaderParameterIterator(Iterator<QuotedStringScanner.Token> src) {
            super(src);
        }

        @Override
        protected void process(QuotedStringScanner.Token token) {
            if (QuotedStringScanner.TokenType.TEXT == token.type()) {
                String segment = token.content().toString().trim();
                int equals = segment.indexOf(61);
                if (equals == -1) {
                    this.type = ParameterType.NO_VALUE;
                    this.name = segment;
                    this.pushParameter();
                } else if (equals == segment.length() - 1) {
                    this.type = ParameterType.QUOTED;
                    this.name = segment.substring(0, equals).trim();
                } else {
                    String key = segment.substring(0, equals).trim();
                    String content = segment.substring(equals + 1).trim();
                    if (key.endsWith("*")) {
                        this.type = ParameterType.EXTENDED;
                        this.name = key.substring(0, key.length() - 1);
                        this.value = HttpHeaderValue.decodeExtendedValue(content);
                    } else {
                        this.type = ParameterType.UNQUOTED;
                        this.name = key;
                        this.value = content;
                    }
                    this.pushParameter();
                }
            } else if (ParameterType.QUOTED == this.type) {
                this.value = token.content().toString();
                this.pushParameter();
            } else {
                throw new IllegalStateException("Got a quoted string, but expecting: <<" + (Object)((Object)this.type) + ">>");
            }
        }

        private void pushParameter() {
            this.add(new HeaderParameter(this.type, this.name, this.value));
            this.type = null;
            this.name = null;
            this.value = null;
        }
    }

    public static enum ParameterType {
        EXTENDED,
        NO_VALUE,
        QUOTED,
        UNQUOTED;

    }

    public static class HeaderParameter {
        private final CharSequence name;
        private final ParameterType type;
        private final CharSequence value;

        private HeaderParameter(ParameterType type, CharSequence name, CharSequence value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public CharSequence name() {
            return this.name;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.name);
            if (this.type == ParameterType.EXTENDED) {
                b.append("*");
            }
            if (this.type != ParameterType.NO_VALUE) {
                b.append("=");
            }
            if (this.type == ParameterType.EXTENDED) {
                b.append(RFC5987Value.encode(this.value));
            } else if (this.type == ParameterType.QUOTED) {
                b.append(QuotedStringValue.encode(this.value));
            } else if (this.type == ParameterType.UNQUOTED) {
                b.append(HttpHeaderValue.encodeToken(this.value));
            }
            return b.toString();
        }

        public ParameterType type() {
            return this.type;
        }

        public CharSequence value() {
            if (this.value instanceof EncodedValue) {
                return ((EncodedValue)this.value).content();
            }
            return this.value;
        }
    }

    public static class Builder {
        private final List<HeaderParameter> parameters = new ArrayList<HeaderParameter>();

        private Builder() {
        }

        public Builder add(HeaderParameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Builder add(HttpHeaderValue value) {
            return this.add(value.parameters());
        }

        public Builder add(Iterable<HeaderParameter> parameters) {
            for (HeaderParameter parameter : parameters) {
                this.add(parameter);
            }
            return this;
        }

        public HttpHeaderValue build() {
            return new HttpHeaderValue(this.parameters);
        }

        public Builder extendedParameter(CharSequence name, CharSequence value) {
            this.parameters.add(new HeaderParameter(ParameterType.EXTENDED, name, value));
            return this;
        }

        public Builder noValueParameter(CharSequence name) {
            this.parameters.add(new HeaderParameter(ParameterType.NO_VALUE, name, null));
            return this;
        }

        public Builder parameter(CharSequence name, CharSequence value) {
            this.parameters.add(new HeaderParameter(ParameterType.QUOTED, name, value));
            return this;
        }

        public Builder parameterType(CharSequence name, ParameterType type) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                HeaderParameter existing = this.parameters.get(i);
                if (!name.equals(existing.name()) || type == existing.type()) continue;
                HeaderParameter replacement = new HeaderParameter(type, existing.name(), existing.value());
                this.parameters.set(i, replacement);
            }
            return this;
        }

        public Builder unquotedParameter(CharSequence name, CharSequence value) {
            this.parameters.add(new HeaderParameter(ParameterType.UNQUOTED, name, value));
            return this;
        }
    }
}

