/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.graph.AdjacencyList;
import oracle.dbtools.common.graph.DepthFirstTraversal;
import oracle.dbtools.common.graph.DirectedGraphCycleException;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.EdgeFormatter;
import oracle.dbtools.common.graph.GraphPaths;
import oracle.dbtools.common.graph.Path;
import oracle.dbtools.common.graph.TextRendererImpl;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.VertexFormatter;
import oracle.dbtools.common.graph.VertexLookup;
import oracle.dbtools.common.graph.Visitor;
import oracle.dbtools.common.util.HasSize;

public class DirectedGraph<V, E>
implements VertexLookup<V, E>,
HasSize,
GraphPaths<V, E> {
    private final Map<V, Integer> indices;
    private final TextRendererImpl<V, E> textRenderer;
    private final List<? extends Vertex<V, E>> vertices;

    DirectedGraph(List<? extends Vertex<V, E>> vertices, TextRendererImpl<V, E> textRenderer) {
        this.vertices = vertices;
        int i = 0;
        this.indices = new HashMap<V, Integer>(vertices.size());
        for (Vertex<V, Vertex<V, E>> vertex : vertices) {
            this.indices.put((Integer)vertex.value(), i);
            ++i;
        }
        this.textRenderer = textRenderer;
    }

    public void accept(Visitor<V, E> visitor, int start) throws ArrayIndexOutOfBoundsException {
        Objects.requireNonNull(visitor);
        if (start < 0 || start >= this.vertices.size()) {
            throw new ArrayIndexOutOfBoundsException(start);
        }
        new DepthFirstTraversal<V, E>(this.vertices, this.textRenderer).accept(visitor, start);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedGraph other = (DirectedGraph)obj;
        return !(this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
        return result;
    }

    public int index(V value) {
        Objects.requireNonNull(value);
        Integer index = this.indices.get(value);
        if (index == null) {
            throw new IllegalArgumentException(value.toString());
        }
        return index;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Builder<V, E> modify() {
        Builder<V, E> b = new Builder<V, E>().edgeFormatter(this.textRenderer.edgeFormatter()).vertexFormatter(this.textRenderer.vertexFormatter());
        for (Vertex<V, E> vertex : this.vertices) {
            Collection<Edge<V, E>> edges = vertex.edges();
            if (edges.isEmpty()) {
                b.vertex(vertex.value());
                continue;
            }
            for (Edge<V, E> edge : edges) {
                b.connect(vertex.value(), edge.destination().value(), edge.value());
            }
        }
        return b;
    }

    @Override
    public Path.Builder<V, E> pathBuilder(int start) {
        Vertex<V, E> vertex = this.vertex(start);
        return new Path.Builder<V, E>(start, vertex, this.textRenderer);
    }

    @Override
    public Iterable<Path<V, E>> paths(int from, int to) {
        return this.paths(from, to, this.textRenderer.edgeChecker());
    }

    @Override
    public Iterable<Path<V, E>> paths(int from, int to, EdgeChecker<V, E> edgeChecker) {
        ArrayList<Path<V, E>> paths = new ArrayList<Path<V, E>>();
        Vertex<V, E> start = this.vertex(from);
        Vertex<V, E> finish = this.vertex(to);
        Path.Builder<V, E> currentPath = this.pathBuilder(from);
        this.paths(paths, currentPath, start, finish, edgeChecker);
        return paths;
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    public TextRendererImpl<V, E> textRenderer() {
        return this.textRenderer;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        return ((TextRendererImpl.RendererBase)((TextRendererImpl.RendererBase)this.textRenderer.using(text)).render(this.vertices)).done().toString();
    }

    @Override
    public Vertex<V, E> vertex(int index) {
        return this.vertices.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paths(List<Path<V, E>> paths, Path.Builder<V, E> current, Vertex<V, E> start, Vertex<V, E> finish, EdgeChecker<V, E> edgeChecker) {
        for (Edge<V, E> edge : start.edges()) {
            if (!edgeChecker.follow(start.value(), edge.value(), edge.destination().value())) continue;
            Vertex<V, E> target = edge.destination();
            if (current.contains(target.value())) {
                return;
            }
            if (finish.equals(target)) {
                paths.add(current.push(edge).build());
                current.pop();
                continue;
            }
            try {
                current.push(edge);
                this.paths(paths, current, target, finish, edgeChecker);
            }
            finally {
                current.pop();
            }
        }
    }

    public static final <V, E> EdgeChecker<V, E> alwaysFollow() {
        return new AlwaysFollow();
    }

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    private static class CycleReporter<V, E>
    implements Visitor<V, E> {
        private final Collection<Path<?, ?>> cycles;
        private final EdgeChecker<V, E> edgeChecker;

        private CycleReporter(Collection<Path<?, ?>> cycles, EdgeChecker<V, E> edgeChecker) {
            this.cycles = cycles;
            this.edgeChecker = edgeChecker;
        }

        @Override
        public boolean cycle(Path<V, E> cycle) {
            Path<V, E> verified = this.checkPath(cycle, this.edgeChecker);
            if (verified != null) {
                this.cycles.add(verified);
            }
            return true;
        }

        @Override
        public void visit(int index, Vertex<V, E> vertex) {
        }

        private Path<V, E> checkPath(Path<V, E> cycle, EdgeChecker<V, E> edgeChecker) {
            if (cycle.hasDirectCycle(edgeChecker)) {
                return cycle;
            }
            return null;
        }
    }

    private static final class AlwaysFollow<V, E>
    implements EdgeChecker<V, E> {
        private AlwaysFollow() {
        }

        @Override
        public boolean follow(V origin, E edge, V destination) {
            return true;
        }
    }

    public static enum CyclePolicy {
        IGNORE,
        REPORT;

    }

    public static class Builder<V, E>
    implements VertexLookup<V, E> {
        private final List<AdjacencyList<V, E>> adjacents;
        private CyclePolicy cyclePolicy = CyclePolicy.IGNORE;
        private EdgeChecker<V, E> edgeChecker = new AlwaysFollow();
        private EdgeFormatter<V, E> edgeFormatter;
        private final Map<V, Integer> indexes;
        private final Set<Integer> roots = new TreeSet<Integer>();
        private int vertexCount = 0;
        private VertexFormatter<V> vertexFormatter;

        Builder() {
            this.adjacents = new ArrayList<AdjacencyList<V, E>>();
            this.indexes = new HashMap<V, Integer>();
        }

        public DirectedGraph<V, E> build() throws DirectedGraphCycleException {
            TextRendererImpl<V, E> textRenderer = new TextRendererImpl<V, E>(this.edgeChecker, this.edgeFormatter, this.vertexFormatter);
            if (CyclePolicy.REPORT.equals((Object)this.cyclePolicy)) {
                this.checkForCycles(this.adjacents, this.roots, this.edgeChecker, textRenderer);
            }
            return new DirectedGraph<V, E>(this.adjacents, textRenderer);
        }

        public Builder<V, E> connect(V from, V to, E using) {
            int f = this.index(from);
            int t = this.index(to);
            this.add(f, t, using);
            return this;
        }

        public Builder<V, E> cyclePolicy(CyclePolicy cyclePolicy) {
            this.cyclePolicy = cyclePolicy;
            return this;
        }

        public Builder<V, E> edgeChecker(EdgeChecker<V, E> edgeChecker) {
            this.edgeChecker = edgeChecker;
            return this;
        }

        public Builder<V, E> edgeFormatter(EdgeFormatter<V, E> edgeFormatter) {
            this.edgeFormatter = edgeFormatter;
            return this;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            return ((TextRendererImpl.RendererBase)((TextRendererImpl.RendererBase)new TextRendererImpl<V, E>(this.edgeChecker, this.edgeFormatter, this.vertexFormatter).using(text)).render(this.adjacents)).done().toString();
        }

        @Override
        public Vertex<V, E> vertex(int index) {
            return this.adjacents.get(index);
        }

        public Builder<V, E> vertex(V value) {
            this.index(value);
            return this;
        }

        public Builder<V, E> vertexFormatter(VertexFormatter<V> vertexFormatter) {
            this.vertexFormatter = vertexFormatter;
            return this;
        }

        private void add(int f, int t, E via) {
            AdjacencyList<V, E> from = this.adjacents.get(f);
            from.add(via, t, this);
            AdjacencyList<V, E> to = this.adjacents.get(t);
            to.incoming();
            this.roots.remove(t);
        }

        private void checkForCycles(List<? extends Vertex<V, E>> vertices, Set<Integer> roots, EdgeChecker<V, E> edgeChecker, TextRendererImpl<V, E> textRenderer) {
            ArrayList cycles = new ArrayList(vertices.size());
            CycleReporter reporter = new CycleReporter(cycles, edgeChecker);
            DepthFirstTraversal traverser = new DepthFirstTraversal(vertices, textRenderer);
            if (roots.isEmpty()) {
                traverser.accept(reporter, 0);
            } else {
                for (int root : roots) {
                    traverser.accept(reporter, root);
                }
            }
            if (!cycles.isEmpty()) {
                throw new DirectedGraphCycleException(cycles);
            }
        }

        private int index(V vertex) {
            Integer existing = this.indexes.get(vertex);
            if (existing == null) {
                int index = this.vertexCount++;
                this.adjacents.add(new AdjacencyList(vertex));
                this.indexes.put((Integer)vertex, index);
                this.roots.add(index);
                return index;
            }
            return existing;
        }
    }
}

