/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;

public class ServiceSelectors {
    @Inject
    ServiceSelectors() {
    }

    public <T> Iterable<T> select(Iterable<T> services, Selector<Class<?>> query) {
        return Iterables.select(services, new SelectByClass(query));
    }

    public <T> Iterable<T> select(Iterable<T> services, ServiceSelectorBuilder query) {
        return this.select(services, query.build());
    }

    public ServiceSelectorBuilder serviceSelectorBuilder() {
        return new ServiceSelectorBuilder();
    }

    private static final class SelectByClass<T>
    implements Selector<T> {
        private final Selector<Class<?>> query;

        private SelectByClass(Selector<Class<?>> query) {
            this.query = query;
        }

        @Override
        public Boolean apply(T service) {
            Class<?> type = service.getClass();
            return (Boolean)this.query.apply(type);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SelectByClass [query=");
            builder.append(this.query);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class ServiceSelectorBuilder {
        private final List<Selector<Class<?>>> selectors = new ArrayList();

        public ServiceSelectorBuilder and(Selector<Class<?>> selector) {
            this.selectors.add(selector);
            return this;
        }

        public Selector<Class<?>> build() {
            return Selectors.and(this.selectors);
        }

        public ServiceSelectorBuilder hasAnnotation(Class<? extends Annotation> annotation, boolean inherited) {
            return this.and(new HasAnnotation(annotation, inherited));
        }
    }

    public static class HasAnnotation
    implements Selector<Class<?>> {
        private final Class<? extends Annotation> annotation;
        private final boolean inherited;

        public HasAnnotation(Class<? extends Annotation> annotation, boolean inherited) {
            this.annotation = annotation;
            this.inherited = inherited;
        }

        @Override
        public Boolean apply(Class<?> type) {
            Boolean result = Boolean.FALSE;
            if (this.inherited) {
                Class<?> currentType = type;
                while (!result.booleanValue() && Object.class != currentType) {
                    result = currentType.isAnnotationPresent(this.annotation);
                    currentType = type.getSuperclass();
                }
            } else {
                result = type.isAnnotationPresent(this.annotation);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HasAnnotation [annotation=");
            builder.append(this.annotation);
            builder.append(", inherited=");
            builder.append(this.inherited);
            builder.append("]");
            return builder.toString();
        }
    }
}

