/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.di.DependencyInjectionException;
import oracle.dbtools.plugin.api.di.annotations.Provides;

class ProviderDescriptor {
    private final transient Class<?>[] provides;
    private final Class<?> type;

    ProviderDescriptor(Class<?> type, Set<Class<?>> ignoredServiceTypes) {
        this(type, ignoredServiceTypes, true);
    }

    ProviderDescriptor(Class<?> type, Set<Class<?>> ignoredServiceTypes, boolean errorOnMissingDescriptor) {
        int modifiers;
        Class<?> superType;
        this.type = type;
        Class<?>[] provides = null;
        Provides descriptor = type.getAnnotation(Provides.class);
        if (descriptor == null && errorOnMissingDescriptor) {
            throw DependencyInjectionException.noProvidesAnnotation(type);
        }
        if (descriptor != null) {
            Class[] explicit;
            for (Class expected : explicit = descriptor.value()) {
                if (expected.isAssignableFrom(type)) continue;
                throw DependencyInjectionException.notAnInstanceOfType(type, expected);
            }
            provides = explicit;
        }
        if (this.empty(provides)) {
            provides = type.getInterfaces();
        }
        if (this.empty(provides) && (superType = type.getSuperclass()) != null && !Object.class.equals(superType) && Modifier.isAbstract(modifiers = superType.getModifiers())) {
            provides = new Class[]{superType};
        }
        if (this.empty(provides = this.filterIgnoredServices(provides, ignoredServiceTypes))) {
            provides = new Class[]{type};
        }
        this.provides = provides;
    }

    private Class<?>[] filterIgnoredServices(Class<?>[] provides, Set<Class<?>> ignoredServiceTypes) {
        LinkedHashSet filtered = new LinkedHashSet(provides.length);
        for (Class<?> serviceType : provides) {
            if (ignoredServiceTypes.contains(serviceType)) continue;
            filtered.add(serviceType);
        }
        return filtered.toArray(new Class[filtered.size()]);
    }

    private boolean empty(Class<?>[] provides) {
        return provides == null || provides.length == 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderDescriptor other = (ProviderDescriptor)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProviderDescriptor [type=");
        builder.append(this.type);
        builder.append(", provides=");
        builder.append(Arrays.toString(this.provides));
        builder.append("]");
        return builder.toString();
    }

    Class<?>[] provides() {
        return this.provides;
    }

    boolean provides(Class<?> type) {
        return oracle.dbtools.common.util.Arrays.contains(type, this.provides);
    }

    Class<?> type() {
        return this.type;
    }
}

