/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import oracle.dbtools.common.logging.LogSink;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.logging.Log;

@Provides
public class LogPipe
implements Log {
    private final int callerStackDepth;
    private final Iterable<LogSink> sinks;
    public static final String DEFAULT_LOG_NAME = "oracle.dbtools";
    private static final int CALLER_STACK_DEPTH = 4;

    @Inject
    public LogPipe(Iterable<LogSink> sinks) {
        this(0, sinks);
    }

    protected LogPipe(int callerStackDepth, Iterable<LogSink> sinks) {
        this.callerStackDepth = callerStackDepth + 4;
        this.sinks = sinks;
    }

    public void fine(String msg) {
        this.log(FINE, msg);
    }

    public void fine(Throwable t) {
        this.log(FINE, t);
    }

    public void finer(String msg) {
        this.log(FINER, msg);
    }

    public void finer(Throwable t) {
        this.log(FINER, t);
    }

    public void finest(String msg) {
        this.log(FINEST, msg);
    }

    public void finest(Throwable t) {
        this.log(FINEST, t);
    }

    public void info(String msg) {
        this.log(INFO, msg);
    }

    public void info(Throwable t) {
        this.log(INFO, t);
    }

    public boolean isLoggable(Level level) {
        boolean loggable = false;
        for (LogSink sink : this.sinks) {
            if (!sink.isLoggable(level)) continue;
            loggable = true;
            break;
        }
        return loggable;
    }

    public void severe(String msg) {
        this.log(SEVERE, msg);
    }

    public void severe(Throwable t) {
        this.log(SEVERE, t);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LogPipe [sinks=");
        builder.append(this.sinks);
        builder.append("]");
        return builder.toString();
    }

    public void warning(String msg) {
        this.log(WARNING, msg);
    }

    public void warning(Throwable t) {
        this.log(WARNING, t);
    }

    protected LogRecord filter(LogRecord lr) {
        return lr;
    }

    private void inferCaller(LogRecord lr) {
        lr.setLoggerName(DEFAULT_LOG_NAME);
        lr.setSourceClassName("");
        lr.setSourceMethodName("");
    }

    private void log(Level level, String msg) {
        LogRecord lr = this.logRecord(level, msg);
        LogRecord filtered = this.filter(lr);
        for (LogSink sink : this.sinks()) {
            sink.log(filtered);
        }
    }

    private void log(Level level, Throwable t) {
        LogRecord lr = this.logRecord(level, "");
        lr.setMessage(t == null ? "" : t.getMessage());
        lr.setThrown(t);
        LogRecord filtered = this.filter(lr);
        for (LogSink sink : this.sinks()) {
            sink.log(filtered);
        }
    }

    private final String logName(StackTraceElement methodCaller) {
        String typeName = methodCaller.getClassName();
        int lastPeriod = typeName.lastIndexOf(46);
        if (lastPeriod == -1) {
            return DEFAULT_LOG_NAME;
        }
        return typeName.substring(0, lastPeriod);
    }

    private LogRecord logRecord(Level level, String msg) {
        LogRecord lr = new LogRecord(level, msg);
        this.inferCaller(lr);
        return lr;
    }

    private Iterable<LogSink> sinks() {
        return this.sinks;
    }
}

