/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import oracle.dbtools.common.TranslatableExceptionBase;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.di.DependencyInjectionMessages;
import oracle.dbtools.plugin.api.i18n.Translatable;

public class DependencyInjectionException
extends TranslatableExceptionBase {
    private static final long serialVersionUID = -184645682988160927L;

    protected DependencyInjectionException(Translatable message) {
        this(message, null);
    }

    protected DependencyInjectionException(Translatable message, Throwable cause) {
        super(message, cause);
    }

    static DependencyInjectionException cannotCreateDependency(String name, Type type) {
        return new DependencyInjectionException(DependencyInjectionException.message("CANNOT_CREATE_DEPENDENCY", "Cannot create dependency for: {0} with type: {1}", name, type));
    }

    static DependencyInjectionException illegalAccess(Member member, IllegalAccessException e) {
        return new DependencyInjectionException(DependencyInjectionException.message("ILLEGAL_ACCESS", "Could not access: {0}", new Object[0]), (Throwable)e);
    }

    static DependencyInjectionException illegalArgument(Member member, IllegalArgumentException e) {
        return new DependencyInjectionException(DependencyInjectionException.message("ILLEGAL_ARGUMENT", "Could not invoke: {0} because an illegal argument was passed", member), (Throwable)e);
    }

    static DependencyInjectionException instantationError(Class<?> type, Throwable e) {
        return new DependencyInjectionException(DependencyInjectionException.message("INSTANTIATION_ERROR", "Error instantiating: {0}", type), e);
    }

    static DependencyInjectionException invocationError(Member member, InvocationTargetException e) {
        return new DependencyInjectionException(DependencyInjectionException.message("INVOCATION_ERROR", "Could not invoke: {0}, due to the following error: {1}", member, e.getCause()), (Throwable)e);
    }

    static DependencyInjectionException ioError(IOException e) {
        return new DependencyInjectionException(DependencyInjectionException.message("IO_ERROR", "Error reading services descriptor", new Object[0]), (Throwable)e);
    }

    static DependencyInjectionException iterableWithGenericTypeParameter(String name, Type type) {
        return new DependencyInjectionException(DependencyInjectionException.message("ITERABLE_WITH_GENERIC_TYPE_PARAMETER", "Error injecting: {0} the generic type of a Iterable<T> instance cannot itself be a generic type: {1}", name, type));
    }

    static DependencyInjectionException noProvidersFound() {
        return new DependencyInjectionException(DependencyInjectionException.message("NO_PROVIDERS_FOUND", "There are no providers defined", new Object[0]));
    }

    static DependencyInjectionException noProvidesAnnotation(Class<?> type) {
        return new DependencyInjectionException(DependencyInjectionException.message("NO_PROVIDES_ANNOTATION", "Type: {0} does not have a @Provides annotation", type));
    }

    static DependencyInjectionException notAnInstanceOfType(Class<?> type, Class<?> expectedType) {
        return new DependencyInjectionException(DependencyInjectionException.message("NOT_AN_INSTANCE_OF_TYPE", "Type: {0} states it provides type: {1}, but it is not an instance of the specified type", type, expectedType));
    }

    static DependencyInjectionException providerWithGenericTypeParameter(String member, Type type) {
        return new DependencyInjectionException(DependencyInjectionException.message("PROVIDER_WITH_GENERIC_TYPE_PARAMETER", "Error injecting: {0} the generic type of a Provider<T> instance cannot itself be a generic type: {1}", member, type));
    }

    static DependencyInjectionException tooManyConstructors(Class<?> type) {
        return new DependencyInjectionException(DependencyInjectionException.message("TOO_MANY_ANNOTATED_CONSTRUCTORS", "Service: {0} is ambiguous, declares more than one constructor annotated with @Inject", type));
    }

    protected static Translatable message(String id, String text, Object ... arguments) {
        return new TranslatableMessage(DependencyInjectionMessages.class, id, text, arguments);
    }
}

