/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import javax.inject.Provider;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.MissingDependencyException;
import oracle.dbtools.common.di.ServiceLocator;
import oracle.dbtools.common.util.Iterables;

final class DeferredProvider<T>
implements Provider<T> {
    private final DependencyConstraints constraints;
    private final ServiceLocator locator;
    private final Class<T> type;

    DeferredProvider(ServiceLocator locator, Class<T> type, DependencyConstraints constraints) {
        this.locator = locator;
        this.type = type;
        this.constraints = constraints;
    }

    public T get() {
        T instance = Iterables.first(this.locator.acquireAll(this.type, this.constraints));
        if (instance == null) {
            throw MissingDependencyException.noProvider(this.type);
        }
        return instance;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeferredProvider [type=");
        builder.append(this.type);
        builder.append(", constraints=");
        builder.append(this.constraints);
        builder.append("]");
        return builder.toString();
    }
}

