/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import java.util.Iterator;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.plugin.api.conf.Configuration;

public abstract class ConfigurationBase
extends AssociativeArrays.Base<String, String>
implements Configuration {
    protected ConfigurationBase() {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationBase other = (ConfigurationBase)obj;
        return !(this.values() == null ? other.values() != null : !this.values().equals(other.values()));
    }

    @Override
    public String get(Object name) {
        return this.get(name.toString());
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String defaultValue) {
        String value = this.values().get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getPassword(String name) {
        String value = this.get(name, null);
        if (value != null && value.startsWith("@")) {
            value = value.substring(1);
            value = Passwords.comingIn(value);
        }
        return value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values() == null ? 0 : this.values().hashCode());
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values().iterator();
    }

    public Iterable<String> propertyNames() {
        return this.values();
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public String toString() {
        return this.values().toString();
    }

    protected abstract AssociativeArray<String, String> values();
}

