/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.app;

import java.util.ArrayList;
import java.util.ListIterator;
import javax.inject.Inject;
import oracle.dbtools.common.app.ApplicationContext;
import oracle.dbtools.common.app.ApplicationLifeCycle;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.Lifecycle;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class PluginLifeCycles
implements ApplicationLifeCycle {
    private final Iterable<Lifecycle> lifecycles;

    @Inject
    public PluginLifeCycles(Iterable<Lifecycle> lifecycles) {
        this.lifecycles = lifecycles;
    }

    @Override
    public void startup(ApplicationContext context) {
        for (Lifecycle lifecycle : this.lifecycles) {
            lifecycle.startup();
        }
    }

    @Override
    public void shutdown(ApplicationContext context) {
        ArrayList lifecycles = new ArrayList();
        Iterables.add(lifecycles, this.lifecycles);
        ListIterator iter = lifecycles.listIterator(lifecycles.size());
        while (iter.hasPrevious()) {
            Lifecycle lifecycle = (Lifecycle)iter.previous();
            lifecycle.shutdown();
        }
    }
}

