/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CommonMessages {
    public static final String URIs_0 = "URIs.0";
    public static final String ServiceLocator_0 = "ServiceLocator.0";
    public static final String NotAvailableException_1 = "NotAvailableException.1";
    public static final String Projects_1 = "Projects.1";
    public static final String Provider_4 = "Provider.4";
    public static final String Projects_0 = "Projects.0";
    public static final String Closeables_0 = "Closeables.0";
    public static final String CryptoMessage_2 = "CryptoMessage.2";
    public static final String CryptoMessage_1 = "CryptoMessage.1";
    public static final String CryptoMessage_0 = "CryptoMessage.0";
    public static final String ConfigDir_0 = "ConfigDir.0";
    public static final String Provider_14 = "Provider.14";
    public static final String FormFields_0 = "FormFields.0";
    public static final String Provider_13 = "Provider.13";
    public static final String Provider_12 = "Provider.12";
    public static final String ServiceLocator_7 = "ServiceLocator.7";
    public static final String Provider_11 = "Provider.11";
    public static final String ServiceLocator_6 = "ServiceLocator.6";
    public static final String Provider_10 = "Provider.10";
    public static final String ServiceLocator_5 = "ServiceLocator.5";
    public static final String ServiceLocator_4 = "ServiceLocator.4";
    public static final String Provider_8 = "Provider.8";
    public static final String URIs_1 = "URIs.1";
    public static final String Provider_7 = "Provider.7";
    public static final String ServiceLocator_2 = "ServiceLocator.2";
    private static final String BUNDLE_NAME = "oracle.dbtools.common.CommonMessages";
    private static final CommonMessages INSTANCE = new CommonMessages();
    private final ResourceBundle m_bundle = ResourceBundle.getBundle("oracle.dbtools.common.CommonMessages", Locale.getDefault(), CommonMessages.class.getClassLoader());

    private CommonMessages() {
    }

    protected String getStringImpl(String key) {
        try {
            return this.m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key) {
        return INSTANCE.getStringImpl(key);
    }

    public static String get(String key) {
        return CommonMessages.getString(key);
    }

    protected String formatImpl(String key, Object ... arguments) {
        try {
            return MessageFormat.format(this.m_bundle.getString(key), arguments);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String format(String key, Object ... arguments) {
        return INSTANCE.formatImpl(key, arguments);
    }

    public final Integer getIntegerImpl(String key) {
        String s = this.getStringImpl(key);
        if (s.length() == 1 && Character.isLetter(s.charAt(0))) {
            return new Integer(s.charAt(0));
        }
        return Integer.valueOf(s);
    }

    public static Integer getInteger(String key) {
        return INSTANCE.getIntegerImpl(key);
    }

    public static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(BUNDLE_NAME, locale == null ? Locale.getDefault() : locale, CommonMessages.class.getClassLoader());
    }

    public static ResourceBundle getBundle() {
        return CommonMessages.INSTANCE.m_bundle;
    }
}

