/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.query;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.query.QueryAliasColumnContext;

public class ValidateQuerySQL {
    private static Queries queries;
    private static final String XMLFILE = "olapdvqmqueries.xml";
    private Logger LOG = Logger.getLogger(ValidateQuerySQL.class.getName());

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), (String)XMLFILE);
                JavaXMLBind.BindToJavaStr((String)string3, (String)string2, (Object)this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        ValidateQuerySQL.queries = queries;
    }

    public String getSQLForCountMembers(LevelDO levelDO) {
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = OLAPDVArb.format("COUNT_OF_DISTINCT_MEMBERS_SQL_REMARK", string2, string);
        String string7 = this.getQuery("get_count_per_level");
        string7 = String.format(string7, string5, string3, string4);
        String string8 = string6 + "\n" + string7;
        return string8;
    }

    public String getSQLForCountDescriptions(LevelDO levelDO) {
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = OLAPDVArb.format("COUNT_OF_DISTINCT_DESCRIPTIONS_SQL_REMARK", string2, string);
        String string7 = this.getQuery("get_count_per_level");
        string7 = String.format(string7, string5, string3, string4);
        String string8 = string6 + "\n" + string7;
        return string8;
    }

    public String getSQLForCountNonUniqueMembers(LevelDO levelDO) {
        LevelDO levelDO2;
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getColumnDataType();
        String string7 = OLAPDVArb.format("COUNT_OF_DUP_MEMBERS_ACROSS_LEVELS_SQL_REMARK", string2, string);
        ArrayList<LevelDO> arrayList = levelDO.getHierarchyDO().getLevelDOs();
        if (arrayList.size() < 2) {
            return null;
        }
        if (arrayList.size() < 3 && (levelDO2 = arrayList.get(0)).getValidState() == LevelDO.ValidStates.VALID_WARNING) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT COUNT(*) FROM \r\n");
        stringBuffer.append("( SELECT DISTINCT " + string5 + "\r\n");
        stringBuffer.append(" FROM " + string3 + "." + string4 + "\r\n");
        if (!(string6.startsWith("VARCHAR") || string6.startsWith("NVARCHAR") || string6.startsWith("CHAR") || string6.startsWith("NCHAR"))) {
            string5 = this.wrapToChar(string5);
        }
        stringBuffer.append(" WHERE " + string5 + " IN (\r\n");
        boolean bl = true;
        for (LevelDO levelDO3 : arrayList) {
            if (levelDO3 == levelDO || levelDO3.getValidState() == LevelDO.ValidStates.VALID_WARNING) continue;
            levelMapDO = levelDO3.getLevelMapDO();
            String string8 = levelMapDO.getColumnName();
            String string9 = levelMapDO.getTableName();
            string6 = levelMapDO.getColumnDataType();
            if (!(string6.startsWith("VARCHAR") || string6.startsWith("NVARCHAR") || string6.startsWith("CHAR") || string6.startsWith("NCHAR"))) {
                string8 = this.wrapToChar(string8);
            }
            if (!bl) {
                stringBuffer.append("  UNION \r\n");
            }
            stringBuffer.append("    SELECT DISTINCT " + string8 + " FROM \r\n");
            stringBuffer.append("    " + string3 + "." + string9 + "\r\n");
            bl = false;
        }
        stringBuffer.append("))");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string7 + "\n");
        stringBuffer2.append(stringBuffer);
        return stringBuffer2.toString();
    }

    private String wrapToChar(String string) {
        return "TO_CHAR(" + string + ")";
    }

    public String getSQLForCountNullMembers(LevelDO levelDO) {
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = OLAPDVArb.format("COUNT_OF_ROWS_WITH_NULL_MEMBERS_SQL_REMARK", string2, string);
        String string7 = String.format(this.getQuery("get_null_count"), string3, string4, string5);
        String string8 = string6 + "\n" + string7;
        return string8;
    }

    public String getSQLForCountNullDescriptions(LevelDO levelDO) {
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = OLAPDVArb.format("COUNT_OF_MEMBERS_WITH_NULL_DESCS_SQL_REMARK", string2, string);
        String string8 = String.format(this.getQuery("get_null_description_count"), string5, string6, string3, string4);
        String string9 = string7 + "\n" + string8;
        return string9;
    }

    public String getSQLForCountMembersWithMultipleDescriptions(LevelDO levelDO) {
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = OLAPDVArb.format("COUNT_OF_MEMBERS_WITH_MULT_DESC_SQL_REMARK", string2, string);
        String string8 = String.format(this.getQuery("get_members_with_multi_desc_count"), string5, string6, string3, string4);
        String string9 = string7 + "\n" + string8;
        return string9;
    }

    public String getSQLForCountDescriptionsAssignedToMultipleMembers(LevelDO levelDO) {
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = OLAPDVArb.format("COUNT_OF_DESC_WITH_MULT_MEMBERS_SQL_REMARK", string2, string);
        String string8 = String.format(this.getQuery("get_desc_with_multi_member_count"), string6, string5, string3, string4);
        String string9 = string7 + "\n" + string8;
        return string9;
    }

    public String getSQLForCountMembersWithMultipleParents(LevelDO levelDO) {
        String string = null;
        boolean bl = false;
        String string2 = levelDO.getName();
        String string3 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string4 = levelMapDO.getOwner();
        String string5 = levelMapDO.getTableName();
        String string6 = levelMapDO.getColumnName();
        String string7 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = null;
        levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string8 = levelMapDO2.getTableName();
        String string9 = levelMapDO2.getColumnName();
        String string10 = OLAPDVArb.format("COUNT_OF_MEMBERS_WITH_MULT_PARENTS_SQL_REMARK", string3, string2);
        if (string8 != null && !string5.equalsIgnoreCase(string8)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery("get_members_with_multi_parents"), string6, string9, string4, string5) : String.format(this.getQuery("get_members_with_multi_parents_snowflake"), string6, string9, string4, string5, string8, string7);
        String string11 = string10 + "\n" + string;
        return string11;
    }

    public String getSQLForCountDescriptionsWithMultipleParentDescriptions(LevelDO levelDO) {
        boolean bl = false;
        String string = levelDO.getName();
        String string2 = levelDO.getHierarchyDO().getName();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string7 = levelMapDO2.getColumnName();
        String string8 = levelMapDO2.getTableName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        String string10 = OLAPDVArb.format("COUNT_OF_DESC_WITH_MULT_PARENT_DESCS_SQL_REMARK", string2, string);
        if (string8 != null && !string4.equalsIgnoreCase(string8)) {
            bl = true;
        }
        String string11 = !bl ? String.format(this.getQuery("get_members_with_multi_parents"), string5, string9, string3, string4) : String.format(this.getQuery("get_desc_with_multi_parents_snowflake"), string5, string9, string3, string4, string8, string6, string7);
        String string12 = string10 + "\n" + string11;
        return string12;
    }

    public String getSQLForDrillOnDistinctMembersAndDescriptions(LevelDO levelDO) {
        String string = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
        String[] stringArray = queryAliasColumnContext.getColumnAliasValues();
        string = string4 != null && string4.equalsIgnoreCase(string5) ? String.format(this.getQuery("get_members_and_descriptions"), string4, string2, string3, stringArray[0]) : String.format(this.getQuery("get_members_and_descriptions2"), string4, string5, string2, string3, stringArray[0], stringArray[1]);
        return string;
    }

    public String getSQLForDrillOnMembersWithNullRows(LevelDO levelDO) {
        String string = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getParentColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string7 = levelMapDO2.getColumnName();
        String string8 = levelMapDO2.getLongDescriptionColumnName();
        String string9 = levelMapDO2.getTableName();
        if (string3 != null && !string3.equalsIgnoreCase(string9)) {
            bl = true;
        }
        if (!bl) {
            ArrayList<String> arrayList = null;
            arrayList = levelDO.getAncestorKeyAndDescriptionColumns();
            boolean bl2 = true;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT DISTINCT ");
            for (String string10 : arrayList) {
                if (bl2) {
                    stringBuffer.append(string10);
                    bl2 = false;
                    continue;
                }
                stringBuffer.append(", " + string10);
            }
            stringBuffer.append(String.format(" FROM %1$s.%2$s WHERE %3$s IS NULL AND ROWNUM < 25000 ORDER BY %4$s, %5$s", string2, string3, string4, string7, string6));
            string = stringBuffer.toString();
        } else {
            string = String.format(this.getQuery("get_null_members_snowflake"), string6, string7, string8, string2, string3, string9, string5, string4);
        }
        return string;
    }

    public String getSQLForDrillOnMembersWithNullDescriptions(LevelDO levelDO) {
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
        String[] stringArray = queryAliasColumnContext.getColumnAliasValues();
        String string5 = String.format(this.getQuery("get_members_with_null_desc"), string3, string4, string, string2, stringArray[0], stringArray[1]);
        return string5;
    }

    public String getSQLForDrillOnNonUniqueMembersAcrossLevel(LevelDO levelDO) {
        Object object;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        String string5 = levelMapDO.getColumnDataType();
        ArrayList<LevelDO> arrayList = levelDO.getHierarchyDO().getLevelDOs();
        if (arrayList.size() < 2) {
            return null;
        }
        if (arrayList.size() < 3 && ((LevelDO)(object = arrayList.get(0))).getValidState() == LevelDO.ValidStates.VALID_WARNING) {
            return null;
        }
        object = new StringBuffer();
        for (LevelDO levelDO2 : arrayList) {
            if (levelDO2 == levelDO || levelDO2.getValidState() == LevelDO.ValidStates.VALID_WARNING) continue;
            string3 = levelMapDO.getColumnName();
            if (!(string5.startsWith("VARCHAR") || string5.startsWith("NVARCHAR") || string5.startsWith("CHAR") || string5.startsWith("NCHAR"))) {
                string3 = this.wrapToChar(string3);
            }
            ((StringBuffer)object).append("SELECT DISTINCT " + string3);
            ((StringBuffer)object).append(", " + string4);
            ((StringBuffer)object).append(" FROM " + string + "." + string2 + "\r\n");
            ((StringBuffer)object).append(" WHERE " + string3 + " IN (\r\n");
            LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
            String string6 = levelMapDO2.getTableName();
            String string7 = levelMapDO2.getColumnName();
            String string8 = levelMapDO2.getColumnDataType();
            if (!(string8.startsWith("VARCHAR") || string8.startsWith("NVARCHAR") || string8.startsWith("CHAR") || string8.startsWith("NCHAR"))) {
                string7 = this.wrapToChar(string7);
            }
            ((StringBuffer)object).append("  SELECT DISTINCT " + string7 + " FROM ");
            ((StringBuffer)object).append(string + "." + string6 + ")\r\n");
            ((StringBuffer)object).append(" UNION \r\n");
        }
        Object object2 = ((StringBuffer)object).toString();
        int n = ((String)object2).length();
        object2 = ((String)object2).substring(0, n - 8);
        return object2;
    }

    public String getSQLForDrillOnMembersWithMultipleDescriptions(LevelDO levelDO) {
        String string = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
        String[] stringArray = queryAliasColumnContext.getColumnAliasValues();
        string = string4 != null && string4.equalsIgnoreCase(string5) ? String.format(this.getQuery("get_members_with_multi_desc"), string4, string5, string2, string3, stringArray[0], stringArray[1]) : String.format(this.getQuery("get_members_with_multi_desc2"), string4, string5, string2, string3, stringArray[0], stringArray[1]);
        return string;
    }

    public String getSQLForDrillOnDescriptionsAssignedToMultipleMembers(LevelDO levelDO) {
        String string = null;
        String string2 = null;
        String string3 = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string4 = levelMapDO.getOwner();
        String string5 = levelMapDO.getTableName();
        String string6 = levelMapDO.getColumnName();
        String string7 = levelMapDO.getLongDescriptionColumnName();
        String string8 = levelMapDO.getParentColumnName();
        QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
        String[] stringArray = queryAliasColumnContext.getColumnAliasValues();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        String string9 = null;
        if (levelDO2 != null && levelDO2.getValidState() == LevelDO.ValidStates.VALID_OK) {
            LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
            string2 = levelMapDO2.getTableName();
            string9 = levelMapDO2.getLongDescriptionColumnName();
            string3 = levelMapDO2.getColumnName();
        }
        string = string6 != null && string6.equalsIgnoreCase(string7) ? (string9 != null ? String.format(this.getQuery("get_desc_with_multi_members"), string7, string6, string9, string4, string5, stringArray[0], stringArray[1], stringArray[2]) : String.format(this.getQuery("get_desc_with_multi_members2"), string7, string6, string4, string5, stringArray[0], stringArray[1])) : (string9 != null ? (string5.equalsIgnoreCase(string2) ? String.format(this.getQuery("get_desc_with_multi_members4"), string7, string6, string9, string4, string5, stringArray[0], stringArray[1], stringArray[2]) : String.format(this.getQuery("get_desc_with_multi_members3"), string7, string6, string9, string4, string5, string2, string8, string3, stringArray[0], stringArray[1], stringArray[2])) : String.format(this.getQuery("get_desc_with_multi_members5"), string7, string6, string4, string5, stringArray[0], stringArray[1]));
        return string;
    }

    public String getSQLForDrillOnMembersWithMultipleParents(LevelDO levelDO) {
        String string = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getParentColumnName();
        QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
        String[] stringArray = queryAliasColumnContext.getColumnAliasValues();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        if (string7 != null && !string3.equalsIgnoreCase(string7)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery("get_member_with_multi_parent"), string4, string8, string5, string9, string2, string3, stringArray[0], stringArray[1], stringArray[2], stringArray[3]) : String.format(this.getQuery("get_member_with_multi_parent_snowflake"), string4, string6, string5, string9, string2, string3, string7, string8, stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        return string;
    }

    public String getSQLForDrillOnDescriptionsWithMultipleParentDescs(LevelDO levelDO) {
        String string = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
        String[] stringArray = queryAliasColumnContext.getColumnAliasValues();
        if (string7 != null && !string3.equalsIgnoreCase(string7)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery("get_desc_with_multi_parent_desc"), string5, string9, string4, string8, string2, string3, stringArray[0], stringArray[1], stringArray[2], stringArray[3]) : String.format(this.getQuery("get_desc_with_multi_parent_desc_snowflake"), string5, string9, string4, string8, string2, string3, string7, string6, stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        return string;
    }

    public String getSQLTextForAppendFixForMembersWithNullDescriptions(LevelDO levelDO, String string, String string2) {
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = levelMapDO.getColumnDataType();
        boolean bl = !string7.startsWith("VARCHAR") && !string7.startsWith("NVARCHAR") && !string7.startsWith("CHAR") && !string7.startsWith("NCHAR");
        String string8 = String.format("UPDATE %1$s.%2$s SET %3$s = ", string3, string4, string6);
        string8 = bl ? string8 + String.format("'%1$s' || TO_CHAR(%2$s) || '%3$s' WHERE %4$s IS NULL", string, string5, string2, string6) : string8 + String.format("'%1$s' || %2$s || '%3$s' WHERE %4$s IS NULL", string, string5, string2, string6);
        return string8;
    }

    public String getSQLTextForNullMembers(LevelDO levelDO) {
        String string = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getParentColumnName();
        String string6 = levelMapDO.getColumnDataType();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getColumnDataType();
        if (string7 != null && !string3.equalsIgnoreCase(string7)) {
            bl = true;
        }
        if (!bl) {
            if ((string6.startsWith("VARCHAR") || string6.startsWith("NVARCHAR") || string6.startsWith("CHAR") || string6.startsWith("NCHAR")) && (string9.startsWith("VARCHAR") || string9.startsWith("NVARCHAR") || string9.startsWith("CHAR") || string9.startsWith("NCHAR"))) {
                string = String.format(this.getQuery("correct_rows_with_null_members"), string2, string3, string4, levelDO.getName(), string8);
            } else if ((string6.startsWith("VARCHAR") || string6.startsWith("NVARCHAR") || string6.startsWith("CHAR") || string6.startsWith("NCHAR")) && string9.startsWith("NUMBER")) {
                string = String.format(this.getQuery("correct_rows_with_null_members_to_char"), string2, string3, string4, levelDO.getName(), string8);
            } else if (string6.startsWith("NUMBER")) {
                string = String.format(this.getQuery("correct_rows_with_null_members_number"), string2, string3, string4, string8);
            }
        } else if ((string6.startsWith("VARCHAR") || string6.startsWith("NVARCHAR") || string6.startsWith("CHAR") || string6.startsWith("NCHAR")) && (string9.startsWith("VARCHAR") || string9.startsWith("NVARCHAR") || string9.startsWith("CHAR") || string9.startsWith("NCHAR"))) {
            string = String.format(this.getQuery("correct_rows_with_null_members"), string2, string3, string4, levelDO.getName(), string5);
        } else if ((string6.startsWith("VARCHAR") || string6.startsWith("NVARCHAR") || string6.startsWith("CHAR") || string6.startsWith("NCHAR")) && string9.startsWith("NUMBER")) {
            string = String.format(this.getQuery("correct_rows_with_null_members_to_char"), string2, string3, string4, levelDO.getName(), string5);
        } else if (string6.startsWith("NUMBER")) {
            string = String.format(this.getQuery("correct_rows_with_null_members_number"), string2, string3, string4, string5);
        }
        return string;
    }

    public String getSQLTextForNullMembersByDescription(LevelDO levelDO) {
        String string = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        string = String.format(this.getQuery("correct_rows_with_null_members_desc"), string2, string3, string4, string5);
        return string;
    }

    public String getSQLTextForMemberFixForMembersWithMultipleDescriptions(LevelDO levelDO, String string, String string2) {
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = levelMapDO.getColumnDataType();
        String string8 = string7.startsWith("VARCHAR") || string7.startsWith("NVARCHAR") || string7.startsWith("CHAR") || string7.startsWith("NCHAR") ? String.format(this.getQuery("correct_by_members_members_with_multi_desc"), string3, string4, string6, string2, string5, string) : String.format(this.getQuery("correct_by_members_members_with_multi_desc2"), string3, string4, string6, string2, string5, string);
        return string8;
    }

    public String getSQLTextForMembersWithMultipleDescriptions(LevelDO levelDO) {
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        String string5 = String.format(this.getQuery("correct_members_with_multi_desc"), string, string2, string3, string4);
        return string5;
    }

    public String getSQLTextForDescriptionsWithMultipleMembers(LevelDO levelDO, String string) {
        String string2 = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = levelMapDO.getColumnDataType();
        boolean bl = !string7.startsWith("VARCHAR") && !string7.startsWith("NVARCHAR") && !string7.startsWith("CHAR") && !string7.startsWith("NCHAR");
        string2 = bl ? String.format(this.getQuery("correct_descriptions_with_multi_members1"), string6, string, string5, string3, string4) : String.format(this.getQuery("correct_descriptions_with_multi_members2"), string6, string, string5, string3, string4);
        return string2;
    }

    public String getSQLTextForConcatFixForDescriptionsWithMultipleMembers(LevelDO levelDO, String string) {
        String string2;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        if (levelDO2 != null && levelDO2.getValidState() == LevelDO.ValidStates.VALID_OK) {
            LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
            String string8 = levelMapDO2.getLongDescriptionColumnName();
            String string9 = levelMapDO2.getTableName();
            String string10 = levelMapDO2.getColumnName();
            string2 = string4.equalsIgnoreCase(string9) ? String.format(this.getQuery("correct_by_concatfix_desc_with_multi_members"), string3, string4, string6, string, string8, string5) : String.format(this.getQuery("correct_by_concatfix_desc_with_multi_members_snowflake"), string3, string4, string6, string, string8, string9, string7, string10, string5);
        } else {
            string2 = null;
        }
        return string2;
    }

    public String getSQLTextForMostCommonFixForDescriptionsWithMultipleMembers(LevelDO levelDO) {
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        String string5 = String.format(this.getQuery("correct_by_most_commonfix_desc_with_multi_members"), string, string2, string4, string3);
        return string5;
    }

    public String getSQLTextForMemberFixForMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2, String string, String string2, String string3) {
        String string4;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getParentColumnName();
        String string7 = levelMapDO.getOwner();
        String string8 = levelMapDO.getTableName();
        String string9 = " ";
        String string10 = levelMapDO.getColumnDataType();
        if (string10.startsWith("VARCHAR") || string10.startsWith("NVARCHAR") || string10.startsWith("CHAR") || string10.startsWith("NCHAR")) {
            string9 = "'";
        }
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        string10 = levelMapDO2.getColumnDataType();
        String string11 = " ";
        if (string10.startsWith("VARCHAR") || string10.startsWith("NVARCHAR") || string10.startsWith("CHAR") || string10.startsWith("NCHAR")) {
            string11 = "'";
        }
        levelMapDO2 = levelDO.getLevelMapDO();
        String string12 = levelMapDO2.getTableName();
        String string13 = levelMapDO2.getColumnName();
        String string14 = levelMapDO2.getLongDescriptionColumnName();
        if (string12 != null && !string8.equalsIgnoreCase(string12)) {
            bl = true;
        }
        if (!bl) {
            string4 = string11.equalsIgnoreCase("'") ? String.format("UPDATE %1$s.%2$s SET %3$s = '%4$s',%n%5$s = '%6$s' WHERE ", string7, string8, string13, string2, string14, string3) : String.format("UPDATE %1$s.%2$s SET %3$s = %4$s,%n%5$s = '%6$s' WHERE ", string7, string8, string13, string2, string14, string3);
            string4 = string9.equalsIgnoreCase("'") ? string4 + String.format("%1$s  = '%2$s'", string5, string) : string4 + String.format("%1$s  = %2$s", string5, string);
        } else {
            string4 = string11.equalsIgnoreCase("'") ? String.format("UPDATE %1$s.%2$s SET %3$s = '%4$s'%n WHERE ", string7, string8, string6, string2) : String.format("UPDATE %1$s.%2$s SET %3$s = %4$s%n WHERE ", string7, string8, string6, string2);
            string4 = string9.equalsIgnoreCase("'") ? string4 + String.format("%1$s = '%2$s'", string5, string) : string4 + String.format("%1$s = %2$s", string5, string);
        }
        return string4;
    }

    public String getSQLTextForConcatFixForMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2, String string) {
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string2 = levelMapDO.getColumnName();
        String string3 = levelMapDO.getParentColumnName();
        String string4 = levelMapDO.getOwner();
        String string5 = levelMapDO.getTableName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string6 = levelMapDO2.getTableName();
        String string7 = levelMapDO2.getColumnName();
        if (string == null || string.length() == 0) {
            string = " ";
        }
        if (string6 != null && !string5.equalsIgnoreCase(string6)) {
            bl = true;
        }
        String string8 = !bl ? String.format(this.getQuery("correct_by_concatfix_members_with_multi_parents"), string4, string5, string2, string, string7) : String.format(this.getQuery("correct_by_concatfix_members_with_multi_parents_snowflake"), string4, string5, string2, string, string3, string7, string6);
        return string8;
    }

    public String getSQLTextForMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2) {
        String string = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getParentColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        if (string7 != null && !string3.equalsIgnoreCase(string7)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery("correct_members_with_multi_parents"), string2, string3, string4, string8, string9) : String.format(this.getQuery("correct_members_with_multi_parents_snowflake"), string2, string3, string4, string6, string9, string7, string8);
        return string;
    }

    public String getSQLTextForMemberFixForDescriptionsWithMultipleParentDescriptions(LevelDO levelDO, LevelDO levelDO2, String string, String string2) {
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getParentColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        if (string7 != null && !string4.equalsIgnoreCase(string7)) {
            bl = true;
        }
        String string10 = !bl ? String.format(this.getQuery("correct_by_members_members_with_multi_desc"), string3, string4, string9, string, string5, string2) : String.format(this.getQuery("correct_by_members_desc_with_multi_desc_snowflake"), string3, string4, string7, string6, string8, string9, string, string5, string2);
        return string10;
    }

    public String getSQLTextForConcatFixForDescriptionsWithMultipleParentDescriptions(LevelDO levelDO, String string) {
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getLongDescriptionColumnName();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string5 = levelMapDO2.getLongDescriptionColumnName();
        if (string == null || string.length() == 0) {
            string = " ";
        }
        String string6 = String.format(this.getQuery("correct_by_concatfix_members_with_multi_parents"), string3, string4, string2, string, string5);
        return string6;
    }

    public String getSQLTextForDescriptionsWithMultipleParentDescriptions(LevelDO levelDO, LevelDO levelDO2) {
        String string = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string6 = levelMapDO2.getTableName();
        String string7 = levelMapDO2.getColumnName();
        String string8 = levelMapDO2.getLongDescriptionColumnName();
        if (string6 != null && !string3.equalsIgnoreCase(string6)) {
            bl = true;
        }
        if (bl) {
            String string9 = levelMapDO.getParentColumnName();
            string = String.format(this.getQuery("correct_multi_desc_parent_desc_snowflake"), string2, string3, string6, string5, string8, string4, string9, string7);
            return string;
        }
        string = String.format(this.getQuery("correct_multi_parent_desc"), string2, string3, string5, string8);
        return string;
    }
}

