/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.olap.provider.reader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.query.QueryManager;

public class AwReader {
    private static Queries queries;
    private static final String XMLFILE = "olapdvreaderqueries.xml";
    private Logger LOG = Logger.getLogger(AwReader.class.getName());
    private final String GET_CURRENT_USER_NAME = "get_current_user_name";
    private final String GET_AW_NAME_FROM_CUBE_NAME = "get_aw_name_from_cube_name";
    private final String GET_DIMENSION_NAME_AND_TYPE = "get_dimension_name_and_type";

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), (String)XMLFILE);
                JavaXMLBind.BindToJavaStr((String)string3, (String)string2, (Object)this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        AwReader.queries = queries;
    }

    public String getCurrentUserNameFromDual() {
        String string = null;
        String string2 = this.getQuery("get_current_user_name");
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getCurrentUserNameFromDual, SQL Exception occurred.", sQLException);
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        string = dBUtil.executeReturnOneCol(string2);
        string = string.toUpperCase();
        return string;
    }

    public String getAwNameFromCubeName(String string, String string2) {
        String string3 = this.getQuery("get_aw_name_from_cube_name");
        Connection connection = null;
        String string4 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getAwNameFromCubeName, SQL Exception occurred.", sQLException);
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("CUBE_NAME", string2);
        string4 = dBUtil.executeReturnOneCol(string3, hashMap);
        return string4;
    }

    public ArrayList<DimensionDO> getDimensionDOs(String string, String string2) {
        String string3 = this.getQuery("get_dimension_name_and_type");
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getDimensionDOs, SQL Exception occurred.", sQLException);
        }
        ArrayList<DimensionDO> arrayList = new ArrayList<DimensionDO>();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AW_NAME", string2);
        hashMap.put("OWNER", string);
        List list = dBUtil.executeReturnList(string3, hashMap);
        for (Map map : list) {
            DimensionDO dimensionDO = new DimensionDO((String)map.get("DIMENSION_NAME"));
            dimensionDO.setDimensionType((String)map.get("DIMENSION_TYPE"));
            arrayList.add(dimensionDO);
        }
        return arrayList;
    }

    public boolean isDimensionMetadataCacheCurrent(String string, List<DimensionDO> list) {
        boolean bl = true;
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method isDimensionMetadataCacheCurrent, SQL Exception occurred.", sQLException);
        }
        QueryManager queryManager = new QueryManager();
        String string2 = null;
        for (DimensionDO dimensionDO : list) {
            string2 = dimensionDO.getLastTimeDimensionModified();
            if (string2 == null) {
                bl = false;
                break;
            }
            String string3 = queryManager.getLastTimeDimensionModified(string, dimensionDO.getName());
            if (string3.equalsIgnoreCase(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

