/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.RootNodeViewer;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;

public class RootNodePanel
extends JPanel {
    private DefaultTableModel m_tableModel;
    private JTable m_table;
    private Component m_parentComponent;
    private RootNodeViewer m_rootNodeViewer;
    private RootNodePanel m_rootPanel;

    public RootNodePanel(Component component, RootNodeViewer rootNodeViewer) {
        this.m_parentComponent = component;
        this.m_rootNodeViewer = rootNodeViewer;
        this.m_rootPanel = this;
        this.jbinit();
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        Object[][] objectArray = this.getModels();
        Object[] objectArray2 = this.getColumnNames();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new JTable(this.m_tableModel);
        this.m_table.setSelectionMode(0);
        this.m_table.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setBackground(Color.WHITE);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public void refreshModelInformation() {
        Object[][] objectArray = this.getModels();
        Object[] objectArray2 = this.getColumnNames();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table.setModel(this.m_tableModel);
        this.m_table.repaint();
    }

    private Object[][] getModels() {
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        int n = validateTopDO.getModels().size();
        Object[][] objectArray = new Object[n][2];
        int n2 = 0;
        for (ValidateModelDO validateModelDO : validateTopDO.getModels()) {
            objectArray[n2][0] = validateModelDO.getName();
            String string = validateModelDO.getLastTimeValidated();
            if (string == null || string.length() == 0) {
                OLAPDVArb.getString("NEVER_VALIDATED");
            } else {
                objectArray[n2][1] = string;
            }
            ++n2;
        }
        return objectArray;
    }

    private String[] getColumnNames() {
        String[] stringArray = new String[]{OLAPDVArb.getString("MODEL_NAME_HEADER"), OLAPDVArb.getString("LAST_TIME_VALIDATED_HEADER")};
        return stringArray;
    }
}

