/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.MessageTable;
import oracle.olapdv.app.MessageTableCellEditor;
import oracle.olapdv.app.ModelViewer;
import oracle.olapdv.olap.model.MessageDO;
import oracle.olapdv.olap.model.ValidateModelDO;

public class ModelMessagePanel
extends JPanel
implements ListSelectionListener {
    private DefaultTableModel tableModel;
    private MessageTable table;
    private Component parentComponent;
    private ModelViewer modelViewer;
    private ValidateModelDO validateModelDO;
    private int lastRow = -1;
    private int lastColumn = -1;
    private int initialRowHeight;

    public ModelMessagePanel(Component component, ModelViewer modelViewer, ValidateModelDO validateModelDO) {
        this.parentComponent = component;
        this.modelViewer = modelViewer;
        this.validateModelDO = validateModelDO;
        this.jbinit();
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBackground(Color.WHITE);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        Object[][] objectArray = new Object[5][1];
        Object[] objectArray2 = this.getColumnNames();
        this.tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.table = new MessageTable(this.tableModel);
        this.setColumnWidths();
        this.table.setSelectionMode(0);
        this.table.setBackground(Color.WHITE);
        this.initialRowHeight = this.table.getRowHeight();
        this.table.setRowHeight(this.initialRowHeight * 3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBackground(Color.WHITE);
        MessageTableCellEditor messageTableCellEditor = new MessageTableCellEditor();
        this.table.setDefaultEditor(Object.class, messageTableCellEditor);
        messageTableCellEditor.setValidateTable(this.table);
        ++gridBagConstraints.gridy;
        this.add((Component)jScrollPane, gridBagConstraints);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (n == this.lastRow && n2 == this.lastColumn) {
            return;
        }
        this.lastRow = n;
        this.lastColumn = n2;
        if (n < 0) {
            return;
        }
        if (n >= this.table.getRowCount()) {
            this.table.editCellAt(this.table.getRowCount() - 1, 2);
            return;
        }
        this.table.editCellAt(n, 2);
    }

    public void refreshMessageData(ValidateModelDO validateModelDO) {
        this.validateModelDO = validateModelDO;
        MessageDO messageDO = validateModelDO.getMetadataValidationMessages();
        Object[][] objectArray = messageDO.getMessages();
        Object[] objectArray2 = this.getColumnNames();
        this.tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.table.setModel(this.tableModel);
        this.setColumnWidths();
        this.table.revalidate();
        this.table.repaint();
    }

    private String[] getColumnNames() {
        String[] stringArray = new String[]{OLAPDVArb.getString("SEVERITY_HEADER"), OLAPDVArb.getString("DIMENSION_HEADER"), OLAPDVArb.getString("MESSAGE_HEADER")};
        return stringArray;
    }

    private void setColumnWidths() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(660);
    }
}

