/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.searchbar.Provider;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.ideimpl.searchbar.SearchBarPrefs;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

@RegisteredByExtension(value="oracle.ide.searchbar")
public final class SearchBarHook
extends HashStructureHook {
    public static final String PROPERTY_PROVIDER_ENABLED = "PROPERTY_PROVIDER_ENABLED";
    private List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private Collection<ProviderReference> providers = new CopyOnWriteArrayList<ProviderReference>();
    private Set<ProviderReference> disabledProviders = Collections.synchronizedSet(new HashSet());
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "searchbar");

    public static SearchBarHook get() {
        return (SearchBarHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    public SearchBarHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                SearchBarHook.this.addProviders(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                SearchBarHook.this.addProviders(e.getCombinedHashStructure());
            }
        });
    }

    Collection<ProviderReference> providers() {
        return this.providers;
    }

    private void addProviders(HashStructure hookHash) {
        List newProviders = hookHash.getAsList("provider");
        if (newProviders != null) {
            Preferences p = Preferences.getPreferences();
            HashSet<String> disabled = new HashSet<String>(SearchBarPrefs.getInstance((PropertyStorage)p).getDisabledProviders());
            for (Object o : newProviders) {
                HashStructure hsProvider = (HashStructure)o;
                String name = hsProvider.getString("name");
                MetaClass clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                ProviderReference ref = new ProviderReference(name, (MetaClass<Provider>)clazz);
                this.providers.add(ref);
                if (!disabled.contains(name)) continue;
                this.disabledProviders.add(ref);
            }
        }
    }

    public ProviderReference referenceFor(Provider provider) {
        for (ProviderReference ref : this.providers()) {
            if (provider != ref.provider()) continue;
            return ref;
        }
        throw new IllegalArgumentException("No ProviderReference for Provider " + provider);
    }

    public boolean isProviderEnabled(ProviderReference providerReference) {
        return !this.disabledProviders.contains(providerReference);
    }

    public static boolean isProviderEnabled(Provider provider) {
        SearchBarHook hook = SearchBarHook.get();
        ProviderReference providerReference = hook.referenceFor(provider);
        return hook.isProviderEnabled(providerReference);
    }

    public void setProviderEnabled(ProviderReference provider, boolean enabled) {
        boolean changed;
        boolean bl = changed = enabled ? this.disabledProviders.remove(provider) : this.disabledProviders.add(provider);
        if (changed) {
            this.updatePrefs();
            this.firePropertyChange(new PropertyChangeEvent(provider.provider(), PROPERTY_PROVIDER_ENABLED, !enabled, enabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrefs() {
        Preferences p = Preferences.getPreferences();
        LinkedList<String> list = new LinkedList<String>();
        Set<ProviderReference> set = this.disabledProviders;
        synchronized (set) {
            for (ProviderReference proRef : this.disabledProviders) {
                list.add(proRef.name());
            }
        }
        SearchBarPrefs.getInstance((PropertyStorage)p).setDisabledProviders(list);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(propertyChangeEvent);
        }
    }
}

