/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.handler;

import java.util.Enumeration;
import java.util.Properties;
import oracle.core.ojdl.logging.HandlerFactoryException;

public class LoggingConfigObj {
    private static final String MAXFILESIZE = "maxFileSize";
    private static final String MAXLOGSIZE = "maxLogSize";
    private static final String BUFFERSIZE = "bufferSize";
    private static final String PATH = "path";
    private static final long DEFAULT_MAX_FILE_SIZE = 10000000L;
    private static final long DEFAULT_MAX_LOG_SIZE = 100000000L;
    private static final int DEFAULT_BUFFER_SIZE = 100;
    public String mPath = null;
    public long mMaxLogSize = 10000000L;
    public long mMaxFileSize = 100000000L;
    public int mBufSize = 100;

    LoggingConfigObj() {
    }

    void getLoggingConfigParameters(Properties properties) throws HandlerFactoryException {
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = properties.getProperty(name);
            if (name.equalsIgnoreCase(PATH)) {
                if (value != null) {
                    this.mPath = value;
                    continue;
                }
                this.mPath = System.getProperty("user.dir");
                continue;
            }
            if (name.equalsIgnoreCase(MAXFILESIZE)) {
                if (value != null) {
                    this.mMaxFileSize = this.getLongProperty(name, value);
                }
                if (this.mMaxFileSize > 0L) continue;
                System.out.println("Invalid parameter : " + this.mMaxFileSize + ". Use default value instead.");
                this.mMaxFileSize = 10000000L;
                continue;
            }
            if (name.equalsIgnoreCase(MAXLOGSIZE)) {
                if (value != null) {
                    this.mMaxLogSize = Long.parseLong(value);
                }
                if (this.mMaxLogSize > 0L) continue;
                System.out.println("Invalid parameter: " + this.mMaxLogSize + ". Use default value instead.");
                this.mMaxLogSize = 100000000L;
                continue;
            }
            if (name.equalsIgnoreCase(BUFFERSIZE)) {
                if (value != null) {
                    this.mBufSize = Integer.parseInt(value);
                }
                if (this.mBufSize >= 0) continue;
                System.out.println("Invalid buffer size: " + this.mBufSize + ". Use default value instead.");
                this.mBufSize = 100;
                continue;
            }
            System.out.println("ADF Logging HandlerFactory ignores invalid logging configuration property: " + name);
        }
        if (this.mMaxLogSize < this.mMaxFileSize) {
            System.out.println("Invalid configuration: maxLogSize " + this.mMaxLogSize + " cannot be less than " + MAXFILESIZE + " " + this.mMaxFileSize);
            System.out.println("Setting maxLogSize to the value of maxFileSize");
            this.mMaxLogSize = this.mMaxFileSize;
        }
    }

    private long getLongProperty(String name, String value) throws HandlerFactoryException {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new HandlerFactoryException("Invalid value for property " + name + ": " + value);
        }
    }
}

