/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.handler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controller.IdeActions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ActionDescriptionPanel;
import oracle.ide.refactoring.DeleteElementActionHandler;
import oracle.ide.refactoring.SimpleDeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ideimpl.navigator.ConcurrencySupport;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.model.IdeUtils;
import oracle.ideimpl.navigator.delete.model.ProjectModel;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeBuilder;
import oracle.ideimpl.navigator.delete.ui.UIUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public final class DeleteProjectActionHandler
extends DeleteElementActionHandler<Project> {
    private final boolean m_canRemoveFromWorkingSet;
    private final Workspace m_activeWorkspace;
    private volatile boolean m_startedBuildingContentsTree = false;
    private JScrollPane m_detailsContents = null;
    private JLabel m_detailsHint = null;
    private volatile JTree m_contentsTree = null;
    private volatile IdeModelTree m_ideModel = null;
    private DeleteOption selectedOption = null;
    private JTree m_errorTree = null;
    private static final Logger LOG = Logger.getLogger(DeleteProjectActionHandler.class.getName());

    private boolean hasError() {
        return this.m_errorTree != null;
    }

    public DeleteProjectActionHandler(Context context) {
        super(context);
        this.m_activeWorkspace = context.getWorkspace();
        this.m_canRemoveFromWorkingSet = WorkingSets.getInstance((Workspace)this.m_activeWorkspace).getCurrentWorkingSet().isEditable();
        this.selectedOption = this.m_canRemoveFromWorkingSet ? DeleteOption.RemoveFromWorkingSet : DeleteOption.RemoveFromParent;
        MessageDialog.getPersistence().setConfirmed(DeleteOption.RemoveFromWorkingSet.key(), Boolean.TRUE);
        MessageDialog.getPersistence().setConfirmed(DeleteOption.RemoveFromParent.key(), Boolean.TRUE);
    }

    protected boolean delete(Project project) {
        switch (this.selectedOption) {
            case EraseFromDisk: {
                return this.deleteFromDisk(project);
            }
            case RemoveFromParent: {
                return this.deleteFromWorkspaceOnly(project);
            }
            case RemoveFromWorkingSet: {
                return this.removeFromWorkingSet(project);
            }
        }
        throw new IllegalArgumentException("Project should be removed from disk, removed from the workspace, or removed from the Working Set");
    }

    private boolean deleteFromDisk(Project project) {
        if (this.hasError()) {
            Assert.println((String)("Failed to delete " + project.getURL().getFile() + " due to " + ((DefaultMutableTreeNode)this.m_errorTree.getModel().getRoot()).getUserObject()));
            return false;
        }
        IdeUtils.removeFromOwner((Node)project, (Context)this.getContext());
        DeleteFileVisitor deletor = new DeleteFileVisitor();
        DeleteProjectActionHandler.deleteProject(project, this.m_ideModel != null ? this.m_ideModel.getExcludedURLs() : new ArrayList(), deletor);
        this.getNondeleted().addAll(deletor.getUndeleted());
        return true;
    }

    private boolean deleteFromWorkspaceOnly(Project projectToDelete) {
        Context currentContext = this.getContext();
        Context copyContext = new Context(currentContext);
        for (TNode projectTNode : ExplorerContext.getTNodes((Context)currentContext)) {
            if (!projectToDelete.equals((Object)projectTNode.getData())) continue;
            ExplorerContext.setTNodes((Context)copyContext, (TNode[])new TNode[]{projectTNode});
        }
        try {
            IdeActions.getFileRemoveFromIDEAction().performAction(copyContext);
        }
        catch (Exception e) {
            FeedbackManager.reportException((String)"Failed to delete project from workspace", (Throwable)e);
        }
        return true;
    }

    private boolean removeFromWorkingSet(Project project) {
        WorkingSet currentWorkingSet = WorkingSets.getInstance((Workspace)this.m_activeWorkspace).getCurrentWorkingSet();
        currentWorkingSet.excludeProject(project, Collections.emptySet());
        UpdateMessage.fireStructureChanged((Subject)this.m_activeWorkspace);
        this.restoreNavSelection(project, currentWorkingSet);
        return true;
    }

    private void restoreNavSelection(final Project project, final WorkingSet workingSet) {
        View view = this.getContext().getView();
        if (view instanceof NavigatorWindow) {
            final TreeExplorer explorer = ((NavigatorWindow)view).getTreeExplorer();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean foundProjectNode = false;
                    TNode activeProjectNode = null;
                    Enumeration tNodes = explorer.getRoot().getChildTNodes();
                    while (tNodes.hasMoreElements()) {
                        Project p;
                        TNode next = (TNode)tNodes.nextElement();
                        if (!foundProjectNode && next.getData() == project) {
                            foundProjectNode = true;
                            if (activeProjectNode == null) continue;
                            break;
                        }
                        if (!(next.getData() instanceof Project) || !workingSet.isIncluded(p = (Project)next.getData())) continue;
                        activeProjectNode = next;
                        if (!foundProjectNode) continue;
                        break;
                    }
                    if (activeProjectNode != null) {
                        explorer.setSelected(activeProjectNode);
                    }
                }
            });
        }
    }

    static final void collectProjectURLsForDeletion(ProjectModel projectModel, List<URL> exclusions, Collection<URL> urlsToDelete) {
        urlsToDelete.add(projectModel.getProject().getURL());
        urlsToDelete.add(URLFactory.newFileURL((File)projectModel.getOutputDirectory()));
        for (URL url : projectModel.getContentRootDirectories()) {
            if (exclusions.contains(url)) continue;
            urlsToDelete.add(url);
        }
    }

    private static void deleteProject(Project project, List<URL> exclusions, DeleteFileVisitor deletor) {
        if (DeleteProjectActionHandler.deleteNode((Node)project)) {
            ProjectModel projectModel = new ProjectModel(project);
            ArrayList<URL> urlsToDelete = new ArrayList<URL>();
            DeleteProjectActionHandler.collectProjectURLsForDeletion(projectModel, exclusions, urlsToDelete);
            FileSystemModelUtils.deleteRecursively((URL[])urlsToDelete.toArray(new URL[urlsToDelete.size()]), (DeleteFileVisitor)deletor);
            DeleteProjectActionHandler.deleteProjectBaseIfEmpty(projectModel, deletor);
        }
    }

    static final void deleteProjectBaseIfEmpty(ProjectModel projectModel, DeleteFileVisitor deletor) {
        File baseDirectory = projectModel.getProjectBaseDirectory();
        if (baseDirectory.exists() && FileSystemModelUtils.isFolderEmpty((File)baseDirectory)) {
            FileSystemModelUtils.deleteRecursively((URL[])new URL[]{URLFactory.newFileURL((File)baseDirectory)}, (DeleteFileVisitor)deletor);
        }
    }

    private void buildProjectContentsTree() {
        Runnable rebuildRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IdeModelTreeBuilder treeBuilder = new IdeModelTreeBuilder();
                    for (Project p : DeleteProjectActionHandler.this.getNodes()) {
                        treeBuilder.project(p);
                    }
                    DeleteProjectActionHandler.this.m_ideModel = treeBuilder.build();
                    DeleteProjectActionHandler.this.m_contentsTree = treeBuilder.build().getTree();
                }
                catch (Throwable t) {
                    try {
                        DeleteProjectActionHandler.this.m_errorTree = UIUtils.createErrorTree((Throwable)t);
                        DeleteProjectActionHandler.this.m_contentsTree = DeleteProjectActionHandler.this.m_errorTree;
                        LOG.log(Level.WARNING, t.toString(), t);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeleteProjectActionHandler.this.m_detailsContents.setViewportView(DeleteProjectActionHandler.this.m_contentsTree);
                                if (DeleteProjectActionHandler.this.m_ideModel != null && DeleteProjectActionHandler.this.m_ideModel.hasOptionalItems()) {
                                    DeleteProjectActionHandler.this.m_detailsHint.setText(DeleteDialogArb.getString((int)18));
                                }
                                DeleteProjectActionHandler.this.deleteDetailsAvailable(true);
                                DeleteProjectActionHandler.this.clearStatus();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        ConcurrencySupport.getSharedExecutor().execute(rebuildRunnable);
    }

    protected Component createDeleteDetailsComponent() {
        JPanel detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsHint = new JLabel();
        this.m_detailsContents = new JScrollPane();
        detailsPanel.add((Component)this.m_detailsContents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        detailsPanel.add((Component)this.m_detailsHint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 0, 8, 0), 0, 0));
        return detailsPanel;
    }

    protected SimpleDeleteActionHandler.DialogTextConfig createDialogTextConfig() {
        boolean singleProjectSelected;
        List projectsToBeDeleted = this.getNodes();
        SimpleDeleteActionHandler.DialogTextConfig textConfig = new SimpleDeleteActionHandler.DialogTextConfig().title(DeleteDialogArb.getString((int)0)).showDetails(DeleteDialogArb.getString((int)7)).hideDetails(DeleteDialogArb.getString((int)8)).confirmTitle(DeleteDialogArb.getString((int)0)).confirmMessage(DeleteDialogArb.getString((int)11));
        boolean bl = singleProjectSelected = projectsToBeDeleted.size() == 1;
        if (singleProjectSelected) {
            textConfig.header(MessageFormat.format(DeleteDialogArb.getString((int)1), IdeModelTree.trimExtension((String)((Project)projectsToBeDeleted.get(0)).getShortLabel()))).description(MessageFormat.format(DeleteDialogArb.getString((int)(this.m_canRemoveFromWorkingSet ? 24 : 2)), this.m_activeWorkspace)).options(new String[]{DeleteDialogArb.getString((int)26), DeleteDialogArb.getString((int)3), DeleteDialogArb.getString((int)5)});
        } else {
            textConfig.header(MessageFormat.format(DeleteDialogArb.getString((int)14), DeleteProjectActionHandler.buildProjectList(projectsToBeDeleted.toArray(new Project[projectsToBeDeleted.size()])))).description(MessageFormat.format(DeleteDialogArb.getString((int)(this.m_canRemoveFromWorkingSet ? 25 : 15)), IdeModelTree.trimExtension((String)this.m_activeWorkspace.getShortLabel()))).options(new String[]{DeleteDialogArb.getString((int)27), DeleteDialogArb.getString((int)16), DeleteDialogArb.getString((int)17)});
        }
        if (!this.m_canRemoveFromWorkingSet) {
            String[] options = textConfig.getOptions();
            String[] newOptions = new String[2];
            System.arraycopy(options, 1, newOptions, 0, 2);
            textConfig.options(newOptions);
        }
        textConfig.helpTopicId("f1_idedconfirmprojectdelete_html");
        return textConfig;
    }

    protected String getConfirmationDlgSkipKey() {
        return this.selectedOption.key();
    }

    private static String buildProjectList(Project ... projects) {
        StringBuilder sb = new StringBuilder();
        for (Project p : projects) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(IdeModelTree.trimExtension((String)p.getShortLabel()));
        }
        return sb.toString();
    }

    private void selectedOptionChanged(DeleteOption deleteOption) {
        this.selectedOption = deleteOption;
        if (deleteOption == DeleteOption.EraseFromDisk) {
            if (!this.doneBuildingProjectContentsTree()) {
                this.deleteDetailsAvailable(false);
                this.setStatus(DeleteDialogArb.getString((int)13), OracleIcons.getIcon((String)"throbber.gif"));
                if (!this.m_startedBuildingContentsTree) {
                    this.m_startedBuildingContentsTree = true;
                    this.buildProjectContentsTree();
                }
            } else {
                this.deleteDetailsAvailable(true);
                this.clearStatus();
            }
        } else {
            this.deleteDetailsAvailable(false);
        }
    }

    private boolean doneBuildingProjectContentsTree() {
        return this.m_contentsTree != null;
    }

    private DeleteOption selectedOption(int optionIndex) {
        if (!this.m_canRemoveFromWorkingSet) {
            ++optionIndex;
        }
        switch (optionIndex) {
            case 0: {
                return DeleteOption.RemoveFromWorkingSet;
            }
            case 1: {
                return DeleteOption.RemoveFromParent;
            }
            case 2: {
                return DeleteOption.EraseFromDisk;
            }
        }
        throw new IllegalComponentStateException("Option selected was in an unknown state:" + optionIndex);
    }

    protected Component createDialogContent() {
        ActionDescriptionPanel actionDescriptionPanel = this.createDefaultDialogContent();
        actionDescriptionPanel.setSelectedOption(0);
        actionDescriptionPanel.addSelectionChangedListener(new ActionDescriptionPanel.OptionSelectionChangedListener(){

            public void selectionChanged(ActionDescriptionPanel.OptionSelectionChangedEvent e) {
                DeleteProjectActionHandler.this.selectedOptionChanged(DeleteProjectActionHandler.this.selectedOption(e.getSelectedIndex()));
            }
        });
        return actionDescriptionPanel;
    }

    private static enum DeleteOption {
        EraseFromDisk,
        RemoveFromParent,
        RemoveFromWorkingSet;


        String key() {
            return ((Object)((Object)this)).getClass().getName() + '.' + this.toString();
        }
    }
}

