/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ElementAttributes;

public class CustomTreeSelectionModel
extends DefaultTreeSelectionModel {
    @Override
    public void setSelectionPaths(TreePath[] paths) {
        if (paths == null || this.hasNullPaths(paths)) {
            return;
        }
        if (paths.length == 0) {
            super.setSelectionPaths(paths);
            return;
        }
        if (this.areParentsEqual(paths, paths[0].getParentPath())) {
            super.setSelectionPaths(paths);
            return;
        }
        if (this.areContainerAncestorsEqual(paths, this.getContainerAncestorPath(paths[0]))) {
            super.setSelectionPaths(paths);
            return;
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0 || this.hasNullPaths(paths)) {
            return;
        }
        TreePath selectedPath = this.getSelectionPath();
        if (selectedPath == null) {
            super.addSelectionPaths(paths);
            return;
        }
        if (this.areParentsEqual(paths, selectedPath.getParentPath())) {
            super.addSelectionPaths(paths);
            return;
        }
        if (this.areContainerAncestorsEqual(paths, this.getContainerAncestorPath(selectedPath))) {
            super.addSelectionPaths(paths);
            return;
        }
    }

    private boolean areParentsEqual(TreePath[] paths, TreePath parent) {
        for (int i = 0; i < paths.length; ++i) {
            TreePath currentParent = paths[i].getParentPath();
            if (parent == null || currentParent == null) {
                if (parent == null && currentParent == null) continue;
                return false;
            }
            if (currentParent.equals(parent)) continue;
            return false;
        }
        return true;
    }

    private boolean areContainerAncestorsEqual(TreePath[] paths, TreePath ancestor) {
        if (ancestor == null) {
            return false;
        }
        for (int i = 0; i < paths.length; ++i) {
            TreePath currentAncestor = this.getContainerAncestorPath(paths[i]);
            if (ancestor == null || currentAncestor == null) {
                if (ancestor == null && currentAncestor == null) continue;
                return false;
            }
            if (currentAncestor.equals(ancestor)) continue;
            return false;
        }
        return true;
    }

    private TreePath getContainerAncestorPath(TreePath path) {
        for (TreePath parent = path.getParentPath(); parent != null; parent = parent.getParentPath()) {
            if (!this.isContainerAncestorPath(parent)) continue;
            return parent;
        }
        return null;
    }

    private boolean isContainerAncestorPath(TreePath path) {
        TNode node = (TNode)path.getLastPathComponent();
        return node.getData().getAttributes().isSet(ElementAttributes.SELECTION_CONTAINER);
    }

    private boolean hasNullPaths(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelectionMode(int mode) {
        super.setSelectionMode(mode);
    }
}

