/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceEfficientStackCache {
    private static final Logger logger = Logger.getLogger(SpaceEfficientStackCache.class.getName());
    private final int highWaterMark;
    private final Object pseudoMapValue = new Object();
    private final LinkedHashMap<String, Object> cacheMap = new LinkedHashMap<String, Object>(4, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            return this.size() > SpaceEfficientStackCache.this.highWaterMark;
        }
    };
    private boolean md5Reported = false;

    public SpaceEfficientStackCache() {
        this(50);
    }

    public SpaceEfficientStackCache(int hwm) {
        this.highWaterMark = hwm;
    }

    public boolean shouldReport(Throwable t) {
        return this.cacheMap.put(this.getDigestString(t), this.pseudoMapValue) == null;
    }

    private String getDigestString(Throwable t) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(this.getStackBytes(t));
            return this.stringify(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            if (!this.md5Reported && logger.isLoggable(Level.WARNING)) {
                this.md5Reported = true;
                logger.log(Level.WARNING, "", e);
            }
            return "BAD MD5";
        }
    }

    private byte[] getStackBytes(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        StringBuilder buf = new StringBuilder(elements.length * 80);
        for (StackTraceElement elem : elements) {
            buf.append(elem.getClassName());
            buf.append(elem.getLineNumber());
        }
        return buf.toString().getBytes();
    }

    private String stringify(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2 + 4);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

