/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.util;

import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import oracle.adf.share.logging.ADFLogger;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SecureParserFactory {
    private static final ADFLogger LOG = ADFLogger.createADFLogger(SecureParserFactory.class);
    private static final String FEATURE_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";

    private SecureParserFactory() {
    }

    public static javax.xml.parsers.SAXParser getSAXParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SecureParserFactory.setFactoryFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        javax.xml.parsers.SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        if (reader instanceof SAXParser) {
            SAXParser oreader = (SAXParser)reader;
            oreader.setEntityDepth(11);
            oreader.setAttribute("oracle.xdkjava.security.entityExpansionCountLimit", (Object)64000);
            oreader.setAttribute("oracle.xdkjava.security.resolveEntityDefault", (Object)Boolean.FALSE);
        }
        return parser;
    }

    private static void setFactoryFeature(SAXParserFactory factory, String feature, boolean value) {
        block2: {
            try {
                factory.setFeature(feature, value);
            }
            catch (Throwable e) {
                Object[] params = new Object[]{feature};
                if (!LOG.isWarning()) break block2;
                LOG.log(Level.WARNING, "CANNOT_SET_FACTORY_FEATURE", params, e);
            }
        }
    }

    private static void setFactoryFeature(TransformerFactory factory, String feature, boolean value) {
        block2: {
            try {
                factory.setFeature(feature, value);
            }
            catch (Throwable e) {
                Object[] params = new Object[]{feature};
                if (!LOG.isWarning()) break block2;
                LOG.log(Level.WARNING, "CANNOT_SET_FACTORY_FEATURE", params, e);
            }
        }
    }

    private static void setFactoryFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        block2: {
            try {
                factory.setFeature(feature, value);
            }
            catch (Throwable e) {
                Object[] params = new Object[]{feature};
                if (!LOG.isWarning()) break block2;
                LOG.log(Level.WARNING, "CANNOT_SET_FACTORY_FEATURE", params, e);
            }
        }
    }

    public static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory.newTransformer();
    }

    public static TransformerFactory getTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory;
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return SecureParserFactory.getBuilderFactory().newDocumentBuilder();
    }

    public static DocumentBuilderFactory getBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        return factory;
    }
}

