/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.platform.mt.jrf;

import com.oracle.jrf.mt.tenant.Tenant;
import java.util.UUID;
import oracle.adf.share.platform.mt.TenantContext;
import oracle.adfinternal.share.platform.mt.jrf.JRFTenant;
import oracle.adfinternal.share.platform.mt.jrf.JRFTenantContextFactory;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;

public final class JRFTenantContext
extends TenantContext {
    private final com.oracle.jrf.mt.tenant.runtime.TenantContext wrappedContext;
    private final JRFTenantContextFactory f;

    public JRFTenantContext(Object wrappedContext, JRFTenantContextFactory factory) {
        this.wrappedContext = (com.oracle.jrf.mt.tenant.runtime.TenantContext)wrappedContext;
        this.f = factory;
    }

    @Override
    public oracle.adf.share.platform.mt.Tenant getCurrentTenant() {
        Tenant wrappedTenant = this.wrappedContext.getTenant();
        if (wrappedTenant != null) {
            String tenantName = wrappedTenant.getTenantName();
            UUID tenantUUID = wrappedTenant.getTenantUUID();
            return new JRFTenant(tenantName, tenantUUID, this.isGlobal());
        }
        return null;
    }

    @Override
    public String getTopLevelDir() {
        return this.wrappedContext.getTopLevelDir();
    }

    @Override
    public String getCurrentPartitionName() {
        ComponentInvocationContext context;
        ComponentInvocationContextManager cicMgr = (ComponentInvocationContextManager)this.f.cicManager;
        if (cicMgr == null) {
            if (!this.f.initCICAccess()) {
                return "DOMAIN";
            }
            cicMgr = (ComponentInvocationContextManager)this.f.cicManager;
        }
        if ((context = cicMgr.getCurrentComponentInvocationContext()) == null) {
            throw new IllegalStateException("ComponentInvocationContext null");
        }
        String partitionName = context.getPartitionName();
        if (partitionName == null || partitionName.length() == 0) {
            throw new IllegalStateException("PartitionName null");
        }
        return partitionName;
    }

    @Override
    public UUID getServiceUUID() {
        return this.wrappedContext.getServiceUUID();
    }

    @Override
    public boolean isGlobal() {
        return this.wrappedContext.isGlobal();
    }
}

