/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.perf;

import java.util.logging.Level;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.adf.share.perf.Counter;
import oracle.adfinternal.share.perf.NounUtil;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.SegregationType;

public class CounterImpl
extends Counter {
    private Event mEvent;

    @Override
    public long getValue() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return -1L;
        }
        Object value = this.mEvent.getValue(2);
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public void increase() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mEvent.occurred();
        if (this.mEnablePerfLog) {
            Object value = this.mEvent.getValue(2);
            this.log(System.currentTimeMillis(), value.toString(), null);
        }
    }

    @Override
    public void reset() {
        if (this.mEvent != null) {
            this.mEvent.reset();
        }
    }

    @Override
    public void destroy() {
        if (this.mEvent != null) {
            this.mEvent.destroy();
        }
    }

    private CounterImpl(Level level, String sensorFullName, Event event) {
        super(level, sensorFullName);
        this.mEvent = event;
    }

    public static Counter createDMSCounter(Level level, String groupName, String name, String type, String desc, SegregationType sgType) {
        if ("__LAZY_NOUN_TYPE__".equals(type)) {
            type = LoggingUtils.getNounType(groupName);
        }
        name = LoggingUtils.standardizeSensorName(name);
        StringBuilder groupNameBuf = LoggingUtils.standardizeGroupName2(groupName);
        groupNameBuf.append('/').append(name).append(" ").append("c");
        String fullName = groupNameBuf.toString();
        ADFPerfSensor counter = SensorTable.getSensor(fullName);
        if (counter != null && counter instanceof Counter) {
            return (Counter)counter;
        }
        Event et = null;
        if (sLogger.isLoggable(level) || LoggingUtils.isDMSLoggingEnabled(level)) {
            Noun parentNoun = NounUtil.registerGroupNameIfNeeded(groupName, sgType, type);
            et = Event.create((Noun)parentNoun, (String)name, (String)desc);
            et.deriveMetric(511);
        }
        Counter tr = new CounterImpl(level, fullName, et);
        tr = (Counter)SensorTable.putSensor(fullName, tr);
        return tr;
    }
}

